/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class QuaquaTreeUI
extends BasicTreeUI {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private int lastWidth;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTreeUI();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor editor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer){

                protected Container createContainer() {
                    return new DefaultTreeCellEditor.EditorContainer(){

                        public void paint(Graphics gr) {
                            Graphics2D g = (Graphics2D)gr;
                            g.setColor(UIManager.getColor("TextField.background"));
                            Component[] c = this.getComponents();
                            for (int i = 0; i < c.length; ++i) {
                                g.fill(c[i].getBounds());
                            }
                            super.paint(g);
                        }
                    };
                }
            };
            return editor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isMetaDown();
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isShiftDown();
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (!event.isPopupTrigger()) {
            super.selectPathForEvent(path, event);
        }
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    public void paint(Graphics gr, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        Graphics2D g = (Graphics2D)gr;
        Object property = this.tree.getClientProperty("Quaqua.Tree.style");
        boolean isStriped = property != null && property.equals("striped");
        Color[] stripes = new Color[]{UIManager.getColor("Tree.alternateBackground.0"), UIManager.getColor("Tree.alternateBackground.1")};
        if (this.treeState == null) {
            return;
        }
        boolean leftToRight = QuaquaUtilities.isLeftToRight(this.tree);
        int width = this.tree.getWidth();
        if (width != this.lastWidth) {
            this.lastWidth = width;
            if (!leftToRight) {
                this.redoTheLayout();
                this.updateSize();
            }
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            boolean isExpanded;
            boolean hasBeenExpanded;
            boolean isLeaf;
            TreePath path;
            TreePath parentPath = initialPath;
            boolean done = false;
            Rectangle bounds = null;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            int rwidth = width - insets.left - insets.left;
            if (isStriped) {
                int startY;
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.treeState.getBounds(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row)) {
                            g.setColor(UIManager.getColor("Tree.selectionBackground"));
                        } else {
                            g.setColor(stripes[row % 2]);
                        }
                        g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
                int rheight = this.tree.getRowHeight();
                if (rheight <= 0) {
                    rheight = this.tree.getFont().getSize() + 4;
                }
                int height = this.tree.getHeight();
                for (int y = startY = bounds != null ? bounds.y + bounds.height : 0; y < height; y += rheight) {
                    g.setColor(stripes[row % 2]);
                    g.fillRect(insets.left, y, rwidth, rheight);
                    ++row;
                }
            } else {
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
                while (!done && paintingEnumerator.hasMoreElements()) {
                    path = paintingEnumerator.nextElement();
                    if (path != null) {
                        isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                        if (isLeaf) {
                            hasBeenExpanded = false;
                            isExpanded = false;
                        } else {
                            isExpanded = this.treeState.getExpandedState(path);
                            hasBeenExpanded = this.tree.hasBeenExpanded(path);
                        }
                        bounds = this.treeState.getBounds(path, boundsBuffer);
                        if (bounds == null) {
                            return;
                        }
                        bounds.x += insets.left;
                        bounds.y += insets.top;
                        if (this.tree.isRowSelected(row)) {
                            g.fillRect(insets.left, bounds.y, rwidth, bounds.height);
                        }
                        if (bounds.y + bounds.height >= endY) {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    ++row;
                }
            }
            paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            row = this.treeState.getRowForPath(initialPath);
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            done = false;
            while (!done && paintingEnumerator.hasMoreElements()) {
                path = paintingEnumerator.nextElement();
                if (path != null) {
                    isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    bounds = this.treeState.getBounds(path, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    bounds.x += insets.left;
                    bounds.y += insets.top;
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (!leftToRight) {
                        bounds.x += 4;
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.rendererPane.removeAll();
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }

    private int getLeadSelectionRow() {
        TreePath leadPath = this.tree.getLeadSelectionPath();
        return leadPath == null ? -1 : this.getRowForPath(this.tree, leadPath);
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        boolean isRowSelected = this.tree.isRowSelected(row);
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), isRowSelected, isExpanded, isLeaf, row, leadIndex == row);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        boolean selectedOnPress;

        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.handleSelection(e);
                this.selectedOnPress = true;
            } else {
                this.selectedOnPress = false;
            }
        }

        void handleSelection(MouseEvent e) {
            if (QuaquaTreeUI.this.tree != null && QuaquaTreeUI.this.tree.isEnabled()) {
                TreePath path;
                if (QuaquaTreeUI.this.isEditing(QuaquaTreeUI.this.tree) && QuaquaTreeUI.this.tree.getInvokesStopCellEditing() && !QuaquaTreeUI.this.stopEditing(QuaquaTreeUI.this.tree)) {
                    return;
                }
                if (QuaquaTreeUI.this.tree.isRequestFocusEnabled()) {
                    QuaquaTreeUI.this.tree.requestFocus();
                }
                if ((path = QuaquaTreeUI.this.getClosestPathForLocation(QuaquaTreeUI.this.tree, e.getX(), e.getY())) != null) {
                    int x;
                    Rectangle bounds = QuaquaTreeUI.this.getPathBounds(QuaquaTreeUI.this.tree, path);
                    if (e.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        QuaquaTreeUI.this.checkForClickInExpandControl(path, e.getX(), e.getY());
                    }
                    if ((x = e.getX()) > bounds.x) {
                        if (x > bounds.x + bounds.width || !QuaquaTreeUI.this.startEditing(path, e)) {
                            // empty if block
                        }
                        QuaquaTreeUI.this.selectPathForEvent(path, e);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed() && !this.selectedOnPress) {
                this.handleSelection(e);
            }
        }
    }

    public class FocusHandler
    extends BasicTreeUI.FocusHandler {
        public FocusHandler() {
            super(QuaquaTreeUI.this);
        }

        public void focusGained(FocusEvent event) {
            super.focusGained(event);
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }

        public void focusLost(FocusEvent event) {
            super.focusLost(event);
            QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        }
    }
}

