/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;
import javax.swing.Icon;

public class WindowsFileSystemView14
extends QuaquaFileSystemView {
    private File computer = new File("\\");
    private File volumesFolder;
    private File desktop;
    private File systemVolume = new File("C:\\");

    public WindowsFileSystemView14() {
        this.volumesFolder = this.getParentDirectory(this.systemVolume);
        this.desktop = new File(this.systemVolume, "WINDOWS\\Desktop");
    }

    public File getComputer() {
        return this.computer;
    }

    public File getSystemVolume() {
        return this.volumesFolder;
    }

    public File[] getRoots() {
        return this.getFiles(this.volumesFolder, true);
    }

    public Boolean isTraversable(File f) {
        return this.target.isTraversable(f);
    }

    public String getSystemDisplayName(File f) {
        return this.target.getSystemDisplayName(f);
    }

    public String getSystemTypeDescription(File f) {
        return this.target.getSystemTypeDescription(f);
    }

    public Icon getSystemIcon(File f) {
        try {
            return this.target.getSystemIcon(f);
        }
        catch (Exception e) {
            System.out.println("WindowsFileSystemView.getSystemIcon " + f + " " + e.getClass());
            return null;
        }
    }

    public boolean isParent(File folder, File file) {
        return this.target.isParent(folder, file);
    }

    public File getChild(File parent, String fileName) {
        return this.target.getChild(parent, fileName);
    }

    public boolean isFileSystem(File f) {
        return this.target.isFileSystem(f);
    }

    public boolean isFileSystemRoot(File dir) {
        return this.target.isFileSystemRoot(dir);
    }

    public boolean isDrive(File dir) {
        return this.target.isDrive(dir);
    }

    public boolean isFloppyDrive(File dir) {
        return this.target.isFloppyDrive(dir);
    }

    public boolean isComputerNode(File dir) {
        return this.target.isComputerNode(dir);
    }

    public File getHomeDirectory() {
        return this.target.getHomeDirectory();
    }

    public File getDefaultDirectory() {
        return this.target.getDefaultDirectory();
    }

    public boolean isRoot(File f) {
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        if (f.equals(this.computer)) {
            return true;
        }
        File[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!roots[i].equals(f)) continue;
            return true;
        }
        return false;
    }
}

