/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.AlphaColorUIResource;
import ch.randelshofer.quaqua.BasicQuaquaLookAndFeel;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.VisualMargin;
import java.awt.Color;
import java.security.AccessControlException;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Quaqua14JaguarLookAndFeel
extends BasicQuaquaLookAndFeel {
    public Quaqua14JaguarLookAndFeel() {
        super("apple.laf.AquaLookAndFeel");
    }

    public String getDescription() {
        return "The Quaqua 14 Jaguar Look and Feel version " + QuaquaManager.getVersion();
    }

    public String getName() {
        return "Quaqua Jaguar";
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaJaguarPrefix = "ch.randelshofer.quaqua.jaguar.QuaquaJaguar";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "ButtonUI", quaquaPrefix + "ButtonUI", "CheckBoxUI", quaquaPrefix + "CheckBoxUI", "ColorChooserUI", quaquaPrefix + "14ColorChooserUI", "FileChooserUI", quaquaJaguarPrefix + "FileChooserUI", "FormattedTextFieldUI", quaquaPrefix + "14" + "FormattedTextFieldUI", "RadioButtonUI", quaquaPrefix + "RadioButtonUI", "ToggleButtonUI", quaquaPrefix + "ToggleButtonUI", "PopupMenuUI", quaquaPrefix + "PopupMenuUI", "SeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "ScrollBarUI", quaquaPrefix + "ScrollBarUI", "ScrollPaneUI", quaquaPrefix + "ScrollPaneUI", "SplitPaneUI", quaquaPrefix + "SplitPaneUI", "SpinnerUI", quaquaPrefix + "14" + "SpinnerUI", "ToolBarSeparatorUI", quaquaPrefix + "ToolBarSeparatorUI", "PopupMenuSeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "TextAreaUI", quaquaPrefix + "TextAreaUI", "TextFieldUI", quaquaPrefix + "TextFieldUI", "PasswordFieldUI", quaquaPrefix + "PasswordFieldUI", "TextPaneUI", quaquaPrefix + "TextPaneUI", "EditorPaneUI", quaquaPrefix + "EditorPaneUI", "TreeUI", quaquaPrefix + "TreeUI", "LabelUI", quaquaPrefix + "LabelUI", "ListUI", quaquaPrefix + "ListUI", "ToolBarUI", quaquaPrefix + "ToolBarUI", "ComboBoxUI", quaquaPrefix + "ComboBoxUI", "TableUI", quaquaPrefix + "TableUI", "TableHeaderUI", quaquaPrefix + "TableHeaderUI", "OptionPaneUI", quaquaPrefix + "OptionPaneUI", "PanelUI", quaquaPrefix + "PanelUI", "ViewportUI", quaquaPrefix + "ViewportUI", "PopupMenuUI", quaquaPrefix + "PopupMenuUI", "RootPaneUI", quaquaPrefix + "14RootPaneUI"};
        table.putDefaults(uiDefaults);
        if (this.isJaguarTabbedPane()) {
            uiDefaults = new Object[]{"TabbedPaneUI", quaquaJaguarPrefix + "TabbedPaneUI"};
            table.putDefaults(uiDefaults);
        }
        if (!this.isUseScreenMenuBar()) {
            uiDefaults = new Object[]{"MenuBarUI", quaquaPrefix + "MenuBarUI", "MenuUI", quaquaPrefix + "MenuUI", "MenuItemUI", quaquaPrefix + "MenuItemUI", "CheckBoxMenuItemUI", quaquaPrefix + "MenuItemUI", "RadioButtonMenuItemUI", quaquaPrefix + "MenuItemUI"};
            table.putDefaults(uiDefaults);
        }
    }

    protected boolean isJaguarTabbedPane() {
        String property;
        try {
            property = QuaquaManager.getProperty("Quaqua.tabLayoutPolicy");
            if (property == null) {
                property = QuaquaManager.getProperty("Quaqua.TabbedPane.design", "auto");
            }
        }
        catch (AccessControlException e) {
            property = "auto";
        }
        return property.equals("auto") || property.equals("jaguar") || property.equals("wrap");
    }

    private boolean isBrushedMetal() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.awt.brushMetalLook", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    private boolean isUseScreenMenuBar() {
        String property;
        try {
            property = QuaquaManager.getProperty("apple.laf.useScreenMenuBar", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        boolean isBrushedMetal = this.isBrushedMetal();
        Object controlBackground = isBrushedMetal ? table.get("control") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/Panel.texture.png");
        Object toolBarBackground = isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/ToolBar.texture.png");
        Object menuBackground = isBrushedMetal ? table.get("menu") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/MenuBar.texture.png");
        Object[] objects = new Object[]{"window", controlBackground, "control", controlBackground, "menu", menuBackground, "listHighlight", table.get("textHighlight"), "listHighlightText", table.get("textHighlightText"), "listHighlightBorder", new ColorUIResource(0x808080)};
        table.putDefaults(objects);
    }

    protected void initDesignDefaults(UIDefaults table) {
        boolean isBrushedMetal = this.isBrushedMetal();
        Object toolBarBackground = isBrushedMetal ? table.get("ToolBar.background") : this.makeTextureColor(0xF4F4F4, "/ch/randelshofer/quaqua/jaguar/images/ToolBar.texture.png");
        Object[] objects = new Object[]{"Separator.foreground", new ColorUIResource(139, 139, 139), "Separator.highlight", new ColorUIResource(243, 243, 243), "Separator.shadow", new ColorUIResource(213, 213, 213), "Separator.border", new VisualMargin(), "ToolBar.background", toolBarBackground};
        table.putDefaults(objects);
        objects = this.isUseScreenMenuBar() ? new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "Menu.checkIcon", Quaqua14JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "RadioButtonMenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6)} : new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "Menu.checkIcon", Quaqua14JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.submenuPopupOffsetY", new Integer(-5), "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "MenuBar.border", new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new Color(128, 128, 128)), "MenuBar.margin", new InsetsUIResource(1, 8, 1, 8), "MenuBar.shadow", null, "MenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "PopupMenu.border", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaMenuBorder"), "RadioButtonMenuItem.checkIcon", Quaqua14JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)};
        table.putDefaults(objects);
        objects = this.isJaguarTabbedPane() ? new Object[]{"TabbedPane.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.contentBorderInsets", new InsetsUIResource(5, 6, 6, 6)} : new Object[]{"TabbedPane.background", new AlphaColorUIResource(0, 0, 0, 0)};
        table.putDefaults(objects);
    }
}

