/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.tiger.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class TigerFileSystemView
extends QuaquaFileSystemView {
    private static final File volumesFolder = new File("/Volumes");
    private static final File networkFolder = new File("/Network");
    private static final File computer = new File("/");
    private static final File systemVolume;
    private FileView fileView = this.createFileView();
    private static final HashSet hiddenTopLevelNames;
    static /* synthetic */ Class class$javax$swing$JComponent;

    private FileView createFileView() {
        JFileChooser aquaFileChooser = new JFileChooser(){

            public void updateUI() {
                try {
                    FileChooserUI ui = (FileChooserUI)Class.forName("apple.laf.AquaFileChooserUI").getMethod("createUI", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = TigerFileSystemView.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).invoke(null, this);
                    this.setUI(ui);
                }
                catch (Exception e) {
                    try {
                        FileChooserUI ui = (FileChooserUI)Class.forName("com.apple.mrj.swing.MacFileChooserUI").getMethod("createUI", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = TigerFileSystemView.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).invoke(null, this);
                        this.setUI(ui);
                    }
                    catch (Exception e2) {
                        e.printStackTrace();
                        e2.printStackTrace();
                        InternalError error = new InternalError(e2.getMessage());
                        throw error;
                    }
                }
            }
        };
        return aquaFileChooser.getUI().getFileView(aquaFileChooser);
    }

    public File getSystemVolume() {
        return systemVolume;
    }

    public File getComputer() {
        return computer;
    }

    public File getParentDirectory(File dir) {
        File parent;
        File file = parent = this.isRoot(dir) ? null : super.getParentDirectory(dir);
        if (parent != null && parent.equals(computer)) {
            parent = systemVolume;
        }
        return parent;
    }

    public File[] getRoots() {
        ArrayList<File> roots = new ArrayList<File>();
        roots.add(computer);
        File[] fileArray = volumesFolder.listFiles();
        if (fileArray != null) {
            roots.addAll(Arrays.asList(fileArray));
        }
        roots.add(networkFolder);
        return roots.toArray(new File[roots.size()]);
    }

    public boolean isHiddenFile(File f) {
        if (f.isHidden()) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '\r') {
            return true;
        }
        return hiddenTopLevelNames.contains(name) && (f.getParent() == null || this.isRoot(f.getParentFile()));
    }

    public boolean isRoot(File aFile) {
        return aFile.equals(computer) || aFile.equals(networkFolder) || aFile.getParentFile() != null && aFile.getParentFile().equals(volumesFolder);
    }

    public Boolean isTraversable(File f) {
        return this.fileView.isTraversable(f);
    }

    public String getSystemDisplayName(File f) {
        return this.fileView.getName(f);
    }

    public String getSystemTypeDescription(File f) {
        return this.fileView.getTypeDescription(f);
    }

    public Icon getSystemIcon(File f) {
        if (f.equals(computer)) {
            return UIManager.getIcon("FileView.computerIcon");
        }
        return this.fileView.getIcon(f);
    }

    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public boolean isFileSystem(File f) {
        return true;
    }

    public boolean isFileSystemRoot(File dir) {
        File parentFile = dir.getParentFile();
        return parentFile == null || parentFile.equals(volumesFolder);
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        File[] volumes = volumesFolder.listFiles();
        File sys = null;
        for (int i = 0; i < volumes.length; ++i) {
            try {
                if (!volumes[i].getCanonicalFile().equals(computer)) continue;
                sys = volumes[i];
                break;
            }
            catch (IOException e) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        systemVolume = sys == null ? computer : sys;
        hiddenTopLevelNames = new HashSet();
        String[] names = new String[]{"AppleShare PDS", "automount", "bin", "Cleanup At Startup", "cores", "Desktop DB", "Desktop DF", "dev", "etc", "mach", "mach_kernel", "mach.sym", "private", "sbin", "Temporary Items", "TheVolumeSettingsFolder", "TheFindByContentFolder", "tmp", "Trash", "usr", "var", "Volumes", "\u0003\u0002\u0001Move&Rename"};
        hiddenTopLevelNames.addAll(Arrays.asList(names));
    }
}

