/*
 * Decompiled with CFR 0.152.
 */
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CompressCss {
    public static void main(String[] args) throws Exception {
        File srcdir = new File(args[1]);
        for (File srcFile : CompressCss.getFiles(srcdir, new ArrayList<File>(30))) {
            String dspPath = srcFile.getPath().replace(".css.dsp.src", ".css.dsp");
            File dspFile = new File(dspPath);
            String uncompressed = CompressCss.loadSource(srcFile);
            if (!dspFile.exists()) {
                dspFile.createNewFile();
            }
            CompressCss.log("Compressing...." + srcFile.getPath());
            InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(uncompressed.getBytes()));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(dspFile), "UTF-8");
            CssCompressor compressor = new CssCompressor((Reader)in);
            compressor.compress((Writer)out, -1);
            in.close();
            out.close();
        }
    }

    private static List<File> getFiles(File dir, List<File> list) {
        String dirName = dir.getName();
        if (".svn".equals(dirName) || ".git".equals(dirName) || "CVS".equals(dirName)) {
            return list;
        }
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                CompressCss.getFiles(f, list);
                ++n2;
            }
        } else if (dir.isFile() && dirName.endsWith(".css.dsp.src")) {
            list.add(dir);
        }
        return list;
    }

    protected static String loadSource(Object src) {
        Reader reader = null;
        if (src instanceof File) {
            try {
                reader = new FileReader((File)src);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (src instanceof InputStream) {
            reader = new InputStreamReader((InputStream)src);
        } else {
            CompressCss.log("Unknow input source");
        }
        reader = new BufferedReader(reader);
        StringWriter w = new StringWriter();
        char[] buf = new char[1024];
        int numRead = 0;
        try {
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                w.append(readData);
                buf = new char[1024];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return w.toString();
    }

    private static void log(String str) {
        System.out.println(str);
    }
}

