/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Liner;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    private Connector originalTarget;
    private Figure targetFigure;
    private ConnectionFigure connection;
    private Point start;
    private Liner liner;

    protected ChangeConnectionHandle(Figure figure) {
        super(figure);
        this.setConnection((ConnectionFigure)figure);
        this.setTargetFigure(null);
    }

    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    protected abstract Connector getTarget();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setLocation(Point2D.Double var1);

    protected abstract Point2D.Double getLocation();

    protected Connector getSource() {
        if (this.getTarget() == this.getConnection().getStartConnector()) {
            return this.getConnection().getEndConnector();
        }
        return this.getConnection().getStartConnector();
    }

    public void trackStart(Point point, int n) {
        this.originalTarget = this.getTarget();
        this.start = point;
        this.liner = this.connection.getLiner();
        this.connection.setLiner(null);
    }

    public void trackStep(Point point, Point point2, int n) {
        Connector connector;
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        Figure figure = this.findConnectableFigure(double_, this.view.getDrawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getSource() == null) {
                if (this.getTargetFigure() != null) {
                    this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
                }
            } else if (this.getTargetFigure() != null && this.canConnect(this.getSource().getOwner(), this.getTargetFigure())) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        if ((connector = this.findConnectionTarget(double_, this.view.getDrawing())) != null) {
            double_ = connector.getAnchor();
        }
        this.setLocation(double_);
    }

    public void trackEnd(Point point, Point point2, int n) {
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        Connector connector = this.findConnectionTarget(double_, this.view.getDrawing());
        if (connector == null) {
            connector = this.originalTarget;
        }
        this.setLocation(double_);
        if (connector != this.originalTarget) {
            this.disconnect();
            this.connect(connector);
        }
        this.connection.setLiner(this.liner);
        this.getConnection().updateConnection();
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector findConnectionTarget(Point2D.Double double_, Drawing drawing) {
        Figure figure = this.findConnectableFigure(double_, drawing);
        if (this.getSource() == null && figure != null) {
            return this.findConnector(double_, figure, this.getConnection());
        }
        if (figure != null && figure.canConnect() && figure != this.originalTarget && !figure.includes(this.getOwner()) && this.canConnect(this.getSource().getOwner(), figure)) {
            return this.findConnector(double_, figure, this.getConnection());
        }
        return null;
    }

    protected abstract boolean canConnect(Figure var1, Figure var2);

    protected Connector findConnector(Point2D.Double double_, Figure figure, ConnectionFigure connectionFigure) {
        return figure.findConnector(double_, connectionFigure);
    }

    public void draw(Graphics2D graphics2D) {
        this.drawCircle(graphics2D, this.getTarget() == null ? Color.red : Color.green, Color.black);
    }

    private Figure findConnectableFigure(Point2D.Double double_, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.connection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.connection;
    }

    protected void setTargetFigure(Figure figure) {
        this.targetFigure = figure;
    }

    protected Figure getTargetFigure() {
        return this.targetFigure;
    }

    protected Rectangle basicGetBounds() {
        Point point = this.view.drawingToView(this.getLocation());
        return new Rectangle(point.x - this.getHandlesize() / 2, point.y - this.getHandlesize() / 2, this.getHandlesize(), this.getHandlesize());
    }
}

