/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ConnectionHandle
extends LocatorHandle {
    private CompositeEdit edit;
    private ConnectionFigure currentConnection;
    private ConnectionFigure prototype;
    private Figure targetFigure;

    public ConnectionHandle(Figure figure, Locator locator, ConnectionFigure connectionFigure) {
        super(figure, locator);
        this.prototype = connectionFigure;
    }

    public void draw(Graphics2D graphics2D) {
        this.drawCircle(graphics2D, Color.blue, Color.blue.darker());
    }

    public void trackStart(Point point, int n) {
        this.setConnection(this.createConnection());
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.edit = new CompositeEdit(resourceBundleUtil.getString("createConnection"));
        this.fireUndoableEditHappened(this.edit);
        Point2D.Double double_ = this.getLocationOnDrawing();
        this.getConnection().setStartPoint(double_);
        this.getConnection().setEndPoint(double_);
        this.view.getDrawing().add(this.getConnection());
    }

    public void trackStep(Point point, Point point2, int n) {
        Connector connector;
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        Figure figure = this.findConnectableFigure(double_, this.view.getDrawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        if ((connector = this.findConnectionTarget(double_, this.view.getDrawing())) != null) {
            double_ = Geom.center(connector.getBounds());
        }
        this.getConnection().setEndPoint(double_);
    }

    public void trackEnd(Point point, Point point2, int n) {
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        Connector connector = this.findConnectionTarget(double_, this.view.getDrawing());
        if (connector != null) {
            this.getConnection().setStartConnector(this.getStartConnector());
            this.getConnection().setEndConnector(connector);
            this.getConnection().updateConnection();
        } else {
            this.view.getDrawing().remove(this.getConnection());
            this.edit.setSignificant(false);
        }
        this.setConnection(null);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
            this.setTargetFigure(null);
        }
        this.fireUndoableEditHappened(this.edit);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.prototype.clone();
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.currentConnection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.currentConnection;
    }

    protected Figure getTargetFigure() {
        return this.targetFigure;
    }

    protected void setTargetFigure(Figure figure) {
        this.targetFigure = figure;
    }

    private Figure findConnectableFigure(Point2D.Double double_, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnectionTarget(Point2D.Double double_, Drawing drawing) {
        Figure figure = this.findConnectableFigure(double_, drawing);
        if (figure != null && figure.canConnect() && !figure.includes(this.getOwner()) && this.getConnection().canConnect(this.getOwner(), figure)) {
            return figure.findConnector(double_, this.getConnection());
        }
        return null;
    }

    private Connector getStartConnector() {
        Point2D.Double double_ = this.getLocationOnDrawing();
        return this.getOwner().findConnector(double_, this.getConnection());
    }
}

