/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTool
extends AbstractTool
implements FigureListener {
    private Map<AttributeKey, Object> attributes;
    private Connector startConnector;
    private Connector endConnector;
    private Connector targetConnector;
    private Figure target;
    private ConnectionFigure connection;
    private int splitPoint;
    private ConnectionFigure editedConnection;
    private Figure createdFigure;
    protected ConnectionFigure prototype;
    protected boolean isPressed;

    public ConnectionTool(ConnectionFigure connectionFigure) {
        this.prototype = connectionFigure;
    }

    public ConnectionTool(ConnectionFigure connectionFigure, Map map) {
        this.prototype = connectionFigure;
        this.attributes = map;
    }

    public ConnectionTool(String string) {
        this(string, null);
    }

    public ConnectionTool(String string, Map<AttributeKey, Object> map) {
        try {
            this.prototype = (ConnectionFigure)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to create ConnectionFigure from " + string);
            internalError.initCause(exception);
            throw internalError;
        }
        this.attributes = map;
    }

    public ConnectionFigure getPrototype() {
        return this.prototype;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.trackConnectors(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.isPressed = true;
        this.getView().clearSelection();
        Point2D.Double double_ = this.viewToDrawing(this.anchor);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
        }
        this.setTargetFigure(this.findConnectionStart(double_, this.getDrawing()));
        if (this.getTargetFigure() != null) {
            this.setStartConnector(this.findConnector(double_, this.target, this.prototype));
            if (this.getStartConnector() != null && this.canConnect(this.getTargetFigure())) {
                Point2D.Double double_2 = this.getStartConnector().getAnchor();
                this.setConnection(this.createFigure());
                this.getConnection().basicSetBounds(double_2, double_2);
                this.getConnection().addFigureListener(this);
                this.setCreatedFigure(this.getConnection());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point2D.Double double_ = this.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (this.getConnection() != null) {
            this.trackConnectors(mouseEvent);
            if (this.getTargetConnector() != null) {
                double_ = this.getTargetConnector().getAnchor();
            }
            ConnectionFigure connectionFigure = this.getConnection();
            this.fireAreaInvalidated(connectionFigure.getDrawBounds());
            connectionFigure.willChange();
            connectionFigure.basicSetBounds(connectionFigure.getStartPoint(), double_);
            connectionFigure.changed();
            this.fireAreaInvalidated(connectionFigure.getDrawBounds());
        } else if (this.editedConnection != null) {
            this.editedConnection.willChange();
            this.editedConnection.setPoint(this.splitPoint, double_);
            this.editedConnection.changed();
        }
    }

    protected boolean canConnect(Figure figure) {
        return this.prototype.canConnect(figure);
    }

    protected boolean canConnect(Figure figure, Figure figure2) {
        return this.prototype.canConnect(figure, figure2);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isPressed = false;
        this.isWorking = false;
        Figure figure = null;
        Point2D.Double double_ = this.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (this.getStartConnector() != null) {
            figure = this.findTarget(double_, this.getDrawing());
        }
        if (figure != null) {
            this.setEndConnector(this.findConnector(double_, figure, this.prototype));
            if (this.getEndConnector() != null) {
                CompositeEdit compositeEdit = new CompositeEdit("Verbindung erstellen");
                this.getDrawing().fireUndoableEditHappened(compositeEdit);
                ConnectionFigure connectionFigure = this.getConnection();
                connectionFigure.willChange();
                connectionFigure.setStartConnector(this.getStartConnector());
                connectionFigure.setEndConnector(this.getEndConnector());
                connectionFigure.basicSetBounds(connectionFigure.getStartPoint(), double_);
                connectionFigure.updateConnection();
                connectionFigure.changed();
                connectionFigure.removeFigureListener(this);
                this.getDrawing().add(connectionFigure);
                this.getDrawing().fireUndoableEditHappened(compositeEdit);
            }
        } else if (this.getConnection() != null) {
            this.getDrawing().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setCreatedFigure(null);
        this.fireToolDone();
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
        }
    }

    protected ConnectionFigure createFigure() {
        ConnectionFigure connectionFigure = (ConnectionFigure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(connectionFigure);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                connectionFigure.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return connectionFigure;
    }

    protected Figure findSource(Point2D.Double double_, Drawing drawing) {
        return this.findConnectableFigure(double_, drawing);
    }

    protected Figure findTarget(Point2D.Double double_, Drawing drawing) {
        Figure figure = this.findConnectableFigure(double_, drawing);
        Figure figure2 = this.getStartConnector().getOwner();
        if (figure != null && this.getConnection() != null && this.canConnect(figure) && this.canConnect(figure2, figure)) {
            return figure;
        }
        return null;
    }

    protected ConnectionFigure findConnection(Point2D.Double double_, Drawing drawing) {
        for (Figure figure : drawing.getFiguresFrontToBack()) {
            if (figure == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.connection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.connection;
    }

    protected void trackConnectors(MouseEvent mouseEvent) {
        Point2D.Double double_ = this.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY()));
        Figure figure = null;
        figure = this.getStartConnector() == null ? this.findSource(double_, this.getDrawing()) : this.findTarget(double_, this.getDrawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getStartConnector() != null) {
                if (this.getTargetFigure() != null && this.canConnect(this.getStartConnector().getOwner(), this.getTargetFigure())) {
                    this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
                }
            } else if (this.getTargetFigure() != null && this.canConnect(this.getTargetFigure())) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        Connector connector = null;
        if (figure != null) {
            connector = this.findConnector(double_, figure, this.prototype);
        }
        if (connector != this.getTargetConnector()) {
            this.setTargetConnector(connector);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.createdFigure != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.transform(this.getView().getDrawingToViewTransform());
            this.createdFigure.draw(graphics2D2);
            graphics2D2.dispose();
        }
    }

    protected Connector findConnector(Point2D.Double double_, Figure figure, ConnectionFigure connectionFigure) {
        return figure.findConnector(double_, connectionFigure);
    }

    protected Figure findConnectionStart(Point2D.Double double_, Drawing drawing) {
        Figure figure = this.findConnectableFigure(double_, drawing);
        if (figure != null && figure.canConnect()) {
            return figure;
        }
        return null;
    }

    protected Figure findConnectableFigure(Point2D.Double double_, Drawing drawing) {
        return drawing.findFigureExcept(double_, this.createdFigure);
    }

    protected void setStartConnector(Connector connector) {
        this.startConnector = connector;
    }

    protected Connector getStartConnector() {
        return this.startConnector;
    }

    protected void setEndConnector(Connector connector) {
        this.endConnector = connector;
    }

    protected Connector getEndConnector() {
        return this.endConnector;
    }

    private void setTargetConnector(Connector connector) {
        this.targetConnector = connector;
    }

    protected Connector getTargetConnector() {
        return this.targetConnector;
    }

    private void setTargetFigure(Figure figure) {
        this.target = figure;
    }

    protected Figure getTargetFigure() {
        return this.target;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected void setCreatedFigure(Figure figure) {
        this.createdFigure = figure;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent figureEvent) {
        this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent figureEvent) {
    }

    @Override
    public void figureChanged(FigureEvent figureEvent) {
    }

    @Override
    public void figureRemoved(FigureEvent figureEvent) {
    }

    @Override
    public void figureRequestRemove(FigureEvent figureEvent) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent figureEvent) {
    }
}

