/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.SelectionTool;
import org.jhotdraw.draw.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegationSelectionTool
extends SelectionTool {
    private Collection<Action> drawingActions;
    private Collection<Action> selectionActions;
    private Timer popupTimer;
    private JPopupMenu popupMenu;

    public DelegationSelectionTool() {
        this(new LinkedList<Action>(), new LinkedList<Action>());
    }

    public DelegationSelectionTool(Collection<Action> collection, Collection<Action> collection2) {
        this.drawingActions = collection;
        this.selectionActions = collection2;
    }

    public void setDrawingActions(Collection<Action> collection) {
        this.drawingActions = collection;
    }

    public void setFigureActions(Collection<Action> collection) {
        this.selectionActions = collection;
    }

    @Override
    public void mousePressed(final MouseEvent mouseEvent) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopupMenu(mouseEvent);
        } else {
            super.mousePressed(mouseEvent);
            this.popupTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DelegationSelectionTool.this.handlePopupMenu(mouseEvent);
                    DelegationSelectionTool.this.popupTimer = null;
                }
            });
            this.popupTimer.setRepeats(false);
            this.popupTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.popupTimer != null) {
            this.popupTimer.stop();
            this.popupTimer = null;
        }
        if (this.popupMenu == null || !this.popupMenu.isVisible()) {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            this.handleDoubleClick(mouseEvent);
        }
    }

    protected void handlePopupMenu(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Figure figure = this.getView().findFigure(point);
        if (figure != null || this.drawingActions.size() > 0) {
            this.showPopupMenu(figure, point, mouseEvent.getComponent());
        } else {
            this.popupMenu = null;
        }
    }

    protected void showPopupMenu(Figure figure, Point point, Component component) {
        Cloneable cloneable;
        JPopupMenu jPopupMenu;
        this.popupMenu = jPopupMenu = new JPopupMenu();
        JMenu jMenu = null;
        String string = null;
        LinkedList<Action> linkedList = new LinkedList<Action>();
        if (figure != null) {
            cloneable = new LinkedList<Action>(figure.getActions(this.viewToDrawing(point)));
            if (linkedList.size() != 0 && ((LinkedList)cloneable).size() != 0) {
                linkedList.add(null);
            }
            linkedList.addAll((Collection<Action>)((Object)cloneable));
            if (linkedList.size() != 0 && this.selectionActions.size() != 0) {
                linkedList.add(null);
            }
            linkedList.addAll(this.selectionActions);
        }
        if (linkedList.size() != 0 && this.drawingActions.size() != 0) {
            linkedList.add(null);
        }
        linkedList.addAll(this.drawingActions);
        cloneable = new HashMap();
        for (Action action : linkedList) {
            JMenuItem jMenuItem;
            if (action != null && action.getValue("submenu") != null) {
                if (string == null || !string.equals(action.getValue("submenu"))) {
                    string = (String)action.getValue("submenu");
                    jMenu = new JMenu(string);
                    jPopupMenu.add(jMenu);
                }
            } else {
                string = null;
                jMenu = null;
            }
            if (action == null) {
                if (jMenu != null) {
                    jMenu.addSeparator();
                    continue;
                }
                jPopupMenu.addSeparator();
                continue;
            }
            if (action.getValue("buttonGroup") != null) {
                ButtonGroup buttonGroup = (ButtonGroup)((HashMap)cloneable).get(action.getValue("buttonGroup"));
                if (buttonGroup == null) {
                    buttonGroup = new ButtonGroup();
                    ((HashMap)cloneable).put(action.getValue("buttonGroup"), buttonGroup);
                }
                jMenuItem = new JRadioButtonMenuItem(action);
                buttonGroup.add(jMenuItem);
                jMenuItem.setSelected(action.getValue("selected") == Boolean.TRUE);
            } else if (action.getValue("selected") != null) {
                jMenuItem = new JCheckBoxMenuItem(action);
                jMenuItem.setSelected(action.getValue("selected") == Boolean.TRUE);
            } else {
                jMenuItem = new JMenuItem(action);
            }
            if (jMenu != null) {
                jMenu.add((Component)jMenuItem);
                continue;
            }
            jPopupMenu.add((Component)jMenuItem);
        }
        jPopupMenu.show(component, point.x, point.y);
    }

    protected void handleDoubleClick(MouseEvent mouseEvent) {
        Point point;
        DrawingView drawingView = this.getView();
        Handle handle = drawingView.findHandle(point = new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (handle != null) {
            handle.trackDoubleClick(point, mouseEvent.getModifiersEx());
        } else {
            Point2D.Double double_ = this.viewToDrawing(point);
            Figure figure = this.getView().findFigure(point);
            Figure figure2 = figure;
            if (figure2 != null) {
                Tool tool = figure2.getTool(double_);
                if (tool == null && (figure2 = this.getDrawing().findFigureInside(double_)) != null) {
                    tool = figure2.getTool(double_);
                }
                if (tool != null) {
                    this.setTracker(tool);
                    tool.mousePressed(mouseEvent);
                } else if (figure.handleMouseClick(double_, mouseEvent, this.getView())) {
                    drawingView.clearSelection();
                    drawingView.addToSelection(figure);
                } else {
                    drawingView.clearSelection();
                    drawingView.addToSelection(figure);
                    drawingView.setHandleDetailLevel(drawingView.getHandleDetailLevel() + 1);
                }
            }
        }
    }
}

