/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeChangeEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalCompositeFigure
extends AbstractCompositeFigure {
    protected HashMap<AttributeKey, Object> attributes = new HashMap();
    private HashSet<AttributeKey> forbiddenAttributes;
    private Figure presentationFigure;
    private PresentationFigureHandler presentationFigureHandler = new PresentationFigureHandler(this);

    public GraphicalCompositeFigure() {
        this(null);
    }

    public GraphicalCompositeFigure(Figure figure) {
        this.setPresentationFigure(figure);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.getPresentationFigure() == null) {
            return super.getBounds();
        }
        return this.getPresentationFigure().getBounds();
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().contains(double_);
        }
        return super.contains(double_);
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().removeNotify(drawing);
        }
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double double_;
        if (this.getPresentationFigure() != null) {
            Rectangle2D.Double double_2 = this.getPresentationFigure().getDrawBounds();
            double_ = super.getFigureDrawBounds();
            if (double_.isEmpty()) {
                double_ = double_2;
            } else {
                double_.add(double_2);
            }
        } else {
            double_ = super.getFigureDrawBounds();
        }
        return double_;
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        if (this.getLayouter() == null) {
            super.basicSetBounds(double_, double_2);
            this.basicSetPresentationFigureBounds(double_, double_2);
        } else {
            Rectangle2D.Double double_3 = this.getLayouter().layout(this, double_, double_2);
            this.basicSetPresentationFigureBounds(new Point2D.Double(double_3.getX(), double_3.getY()), new Point2D.Double(Math.max(double_2.x, (double)((int)double_3.getMaxX())), Math.max(double_2.y, (double)((int)double_3.getMaxY()))));
            this.invalidate();
        }
    }

    protected void superBasicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        super.basicSetBounds(double_, double_2);
    }

    protected void basicSetPresentationFigureBounds(Point2D.Double double_, Point2D.Double double_2) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().basicSetBounds(double_, double_2);
        }
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        super.basicTransform(affineTransform);
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().basicTransform(affineTransform);
        }
    }

    @Override
    public void drawFigure(Graphics2D graphics2D) {
        this.drawPresentationFigure(graphics2D);
        super.drawFigure(graphics2D);
    }

    protected void drawPresentationFigure(Graphics2D graphics2D) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().draw(graphics2D);
        }
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            MoveHandle.addMoveHandles(this, linkedList);
        }
        return linkedList;
    }

    public void setPresentationFigure(Figure figure) {
        if (this.presentationFigure != null) {
            this.presentationFigure.removeFigureListener(this.presentationFigureHandler);
            this.presentationFigure.removeUndoableEditListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.removeNotify(this.getDrawing());
            }
        }
        this.presentationFigure = figure;
        if (this.presentationFigure != null) {
            this.presentationFigure.addFigureListener(this.presentationFigureHandler);
            this.presentationFigure.addUndoableEditListener(this.presentationFigureHandler);
            if (this.getDrawing() != null) {
                this.presentationFigure.addNotify(this.getDrawing());
            }
        }
    }

    public Figure getPresentationFigure() {
        return this.presentationFigure;
    }

    @Override
    public GraphicalCompositeFigure clone() {
        GraphicalCompositeFigure graphicalCompositeFigure = (GraphicalCompositeFigure)super.clone();
        Figure figure = graphicalCompositeFigure.presentationFigure = this.presentationFigure == null ? null : (Figure)this.presentationFigure.clone();
        if (graphicalCompositeFigure.presentationFigure != null) {
            graphicalCompositeFigure.presentationFigure.addFigureListener(graphicalCompositeFigure.presentationFigureHandler);
            graphicalCompositeFigure.presentationFigure.addUndoableEditListener(graphicalCompositeFigure.presentationFigureHandler);
        }
        return graphicalCompositeFigure;
    }

    @Override
    public void remap(HashMap<Figure, Figure> hashMap) {
        super.remap(hashMap);
        if (this.presentationFigure != null) {
            this.presentationFigure.remap(hashMap);
        }
    }

    @Override
    public void setAttribute(AttributeKey attributeKey, Object object) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey)) {
            this.willChange();
            if (this.getPresentationFigure() != null) {
                this.getPresentationFigure().setAttribute(attributeKey, object);
            }
            super.setAttribute(attributeKey, object);
            Object object2 = this.attributes.put(attributeKey, object);
            this.fireAttributeChanged(attributeKey, object2, object);
            this.fireUndoableEditHappened(new AttributeChangeEdit(this, attributeKey, object2, object));
            this.changed();
        }
    }

    @Override
    public void basicSetAttribute(AttributeKey attributeKey, Object object) {
        if (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey)) {
            if (this.getPresentationFigure() != null) {
                this.getPresentationFigure().basicSetAttribute(attributeKey, object);
            }
            super.basicSetAttribute(attributeKey, object);
            Object object2 = this.attributes.put(attributeKey, object);
        }
    }

    public void setAttributeEnabled(AttributeKey attributeKey, boolean bl) {
        if (this.forbiddenAttributes == null) {
            this.forbiddenAttributes = new HashSet();
        }
        if (bl) {
            this.forbiddenAttributes.remove(attributeKey);
        } else {
            this.forbiddenAttributes.add(attributeKey);
        }
    }

    @Override
    public Object getAttribute(AttributeKey attributeKey) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(attributeKey);
        }
        return !this.attributes.containsKey(attributeKey) ? attributeKey.getDefaultValue() : this.attributes.get(attributeKey);
    }

    protected void applyAttributesTo(Figure figure) {
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            figure.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    protected void writeAttributes(DOMOutput dOMOutput) throws IOException {
        Figure figure = (Figure)dOMOutput.getPrototype();
        boolean bl = false;
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            Object t;
            Object t2;
            AttributeKey attributeKey = entry.getKey();
            if (this.forbiddenAttributes != null && this.forbiddenAttributes.contains(attributeKey) || (t2 = attributeKey.get(figure)) == (t = attributeKey.get(this)) && (t2 == null || t == null || t2.equals(t))) continue;
            if (!bl) {
                dOMOutput.openElement("a");
                bl = true;
            }
            dOMOutput.openElement(attributeKey.getKey());
            dOMOutput.writeObject(entry.getValue());
            dOMOutput.closeElement();
        }
        if (bl) {
            dOMOutput.closeElement();
        }
    }

    protected void readAttributes(DOMInput dOMInput) throws IOException {
        if (dOMInput.getElementCount("a") > 0) {
            dOMInput.openElement("a");
            for (int i = dOMInput.getElementCount() - 1; i >= 0; --i) {
                dOMInput.openElement(i);
                String string = dOMInput.getTagName();
                Object object = dOMInput.readObject();
                AttributeKey attributeKey = this.getAttributeKey(string);
                if (attributeKey != null && attributeKey.isAssignable(object) && (this.forbiddenAttributes == null || !this.forbiddenAttributes.contains(attributeKey))) {
                    this.setAttribute(attributeKey, object);
                }
                dOMInput.closeElement();
            }
            dOMInput.closeElement();
        }
    }

    protected AttributeKey getAttributeKey(String string) {
        return AttributeKeys.supportedAttributeMap.get(string);
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>(this.attributes);
    }

    public Point2D.Double chop(Point2D.Double double_) {
        Rectangle2D.Double double_2 = this.getBounds();
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            double d;
            switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
                default: {
                    d = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case OUTSIDE: {
                    d = AttributeKeys.getStrokeTotalWidth(this);
                    break;
                }
                case INSIDE: {
                    d = 0.0;
                }
            }
            Geom.grow(double_2, d, d);
        }
        return Geom.angleToPoint(double_2, Geom.pointToAngle(double_2, double_));
    }

    private static class PresentationFigureHandler
    implements FigureListener,
    UndoableEditListener {
        private GraphicalCompositeFigure owner;

        private PresentationFigureHandler(GraphicalCompositeFigure graphicalCompositeFigure) {
            this.owner = graphicalCompositeFigure;
        }

        public void figureRequestRemove(FigureEvent figureEvent) {
            this.owner.remove(figureEvent.getFigure());
        }

        public void figureRemoved(FigureEvent figureEvent) {
        }

        public void figureChanged(FigureEvent figureEvent) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(figureEvent);
                this.owner.changed();
            }
        }

        public void figureAdded(FigureEvent figureEvent) {
        }

        public void figureAttributeChanged(FigureEvent figureEvent) {
        }

        public void figureAreaInvalidated(FigureEvent figureEvent) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(figureEvent.getInvalidatedArea());
            }
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            this.owner.fireUndoableEditHappened(undoableEditEvent.getEdit());
        }
    }
}

