/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleMulticaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleTracker
extends AbstractTool {
    private Handle masterHandle;
    private HandleMulticaster multicaster;
    private Point anchor;

    public HandleTracker(Handle handle) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }

    public HandleTracker(Handle handle, Collection<Handle> collection) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(collection);
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.getView().setCursor(this.masterHandle.getCursor());
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.getView().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.multicaster.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.multicaster.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.multicaster.keyTyped(keyEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.multicaster.trackDoubleClick(new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.multicaster.trackStep(this.anchor, new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.anchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.multicaster.trackStart(this.anchor, mouseEvent.getModifiersEx(), this.getView());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.multicaster.trackEnd(this.anchor, new Point(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiersEx(), this.getView());
        this.fireToolDone();
    }
}

