/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAreaFigure
extends AttributedFigure
implements TextHolder {
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private boolean editable = true;
    private static final BasicStroke dashes = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private transient TextLayout textLayout;

    public TextAreaFigure() {
        this("Text");
    }

    public TextAreaFigure(String string) {
        this.setText(string);
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String string) {
        this.setAttribute(AttributeKeys.TEXT, string);
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.bounds.x = Math.min(double_.x, double_2.x);
        this.bounds.y = Math.min(double_.y, double_2.y);
        this.bounds.width = Math.max(1.0, Math.abs(double_2.x - double_.x));
        this.bounds.height = Math.max(1.0, Math.abs(double_2.y - double_.y));
        this.textLayout = null;
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        return this.bounds.contains(double_);
    }

    @Override
    public Insets2DDouble getInsets() {
        double d = Math.ceil(AttributeKeys.STROKE_WIDTH.get(this) / 2.0);
        Insets2DDouble insets2DDouble = new Insets2DDouble(4.0, 4.0, 4.0, 4.0);
        return new Insets2DDouble(insets2DDouble.top + d, insets2DDouble.left + d, insets2DDouble.bottom + d, insets2DDouble.right + d);
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    protected void drawText(Graphics2D graphics2D) {
        if (this.getText() != null || this.isEditable()) {
            Font font = this.getFont();
            boolean bl = AttributeKeys.FONT_UNDERLINED.get(this);
            Insets2DDouble insets2DDouble = this.getInsets();
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.bounds.x + insets2DDouble.left, this.bounds.y + insets2DDouble.top, this.bounds.width - insets2DDouble.left - insets2DDouble.right, this.bounds.height - insets2DDouble.top - insets2DDouble.bottom);
            float f = (float)double_.x;
            float f2 = (float)Math.max((double)(f + 1.0f), double_.x + double_.width);
            float f3 = (float)double_.y;
            if (f < f2) {
                float f4 = this.getTabSize() * graphics2D.getFontMetrics(font).charWidth('m');
                float[] fArray = new float[(int)(double_.width / (double)f4)];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)(double_.x + (double)((int)(f4 * (float)(i + 1))));
                }
                if (this.getText() != null) {
                    Shape shape = graphics2D.getClip();
                    graphics2D.clip(double_);
                    String[] stringArray = this.getText().split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length() == 0) {
                            stringArray[i] = " ";
                        }
                        AttributedString attributedString = new AttributedString(stringArray[i]);
                        attributedString.addAttribute(TextAttribute.FONT, font);
                        if (bl) {
                            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                        }
                        int n = new StringTokenizer(stringArray[i], "\t").countTokens() - 1;
                        f3 = this.drawParagraph(graphics2D, attributedString.getIterator(), f3, f, f2, fArray, n);
                        if ((double)f3 > double_.y + double_.height) break;
                    }
                    graphics2D.setClip(shape);
                }
            }
            if (f >= f2 || (double)f3 > double_.y + double_.height) {
                graphics2D.setColor(Color.red);
                graphics2D.setStroke(dashes);
                graphics2D.draw(new Line2D.Double(double_.x, double_.y + double_.height - 1.0, double_.x + double_.width - 1.0, double_.y + double_.height - 1.0));
            }
        }
    }

    private float drawParagraph(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator, float f, float f2, float f3, float[] fArray, int n) {
        int[] nArray = new int[n + 1];
        int n2 = 0;
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            if (c == '\t') {
                nArray[n2++] = attributedCharacterIterator.getIndex();
            }
            c = attributedCharacterIterator.next();
        }
        nArray[n] = attributedCharacterIterator.getEndIndex() - 1;
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.getFontRenderContext());
        int n3 = 0;
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = f2;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            LinkedList<Float> linkedList2 = new LinkedList<Float>();
            while (!bl2) {
                float f7 = f3 - f6;
                object = null;
                object = lineBreakMeasurer.nextLayout(f7, nArray[n3] + 1, bl);
                if (object != null) {
                    linkedList.add(object);
                    linkedList2.add(Float.valueOf(f6));
                    f6 += ((TextLayout)object).getAdvance();
                    f4 = Math.max(f4, ((TextLayout)object).getAscent());
                    f5 = Math.max(f5, ((TextLayout)object).getDescent() + ((TextLayout)object).getLeading());
                } else {
                    bl2 = true;
                }
                bl = true;
                if (lineBreakMeasurer.getPosition() == nArray[n3] + 1) {
                    ++n3;
                }
                if (lineBreakMeasurer.getPosition() == attributedCharacterIterator.getEndIndex()) {
                    bl2 = true;
                } else if (fArray.length == 0 || f6 >= fArray[fArray.length - 1]) {
                    bl2 = true;
                }
                if (bl2) continue;
                int n4 = 0;
                while (f6 >= fArray[n4]) {
                    ++n4;
                }
                f6 = fArray[n4];
            }
            f += f4;
            Iterator iterator = linkedList.iterator();
            object = linkedList2.iterator();
            while (iterator.hasNext()) {
                TextLayout textLayout = (TextLayout)iterator.next();
                float f8 = ((Float)object.next()).floatValue();
                textLayout.draw(graphics2D, f8, f);
            }
            f += f5;
        }
        return f;
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        graphics2D.fill(this.bounds);
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        graphics2D.draw(this.bounds);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.bounds.getBounds2D();
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList linkedList = (LinkedList)super.createHandles(n);
        if (n == 0) {
            linkedList.add(new FontSizeHandle(this));
        }
        return linkedList;
    }

    @Override
    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        return this.isEditable() && this.contains(double_) ? new TextAreaTool(this) : null;
    }

    protected void readBounds(DOMInput dOMInput) throws IOException {
        this.bounds.x = dOMInput.getAttribute("x", 0.0);
        this.bounds.y = dOMInput.getAttribute("y", 0.0);
        this.bounds.width = dOMInput.getAttribute("w", 0.0);
        this.bounds.height = dOMInput.getAttribute("h", 0.0);
    }

    protected void writeBounds(DOMOutput dOMOutput) throws IOException {
        dOMOutput.addAttribute("x", this.bounds.x);
        dOMOutput.addAttribute("y", this.bounds.y);
        dOMOutput.addAttribute("w", this.bounds.width);
        dOMOutput.addAttribute("h", this.bounds.height);
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readBounds(dOMInput);
        this.readAttributes(dOMInput);
        this.textLayout = null;
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        this.writeBounds(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    @Override
    public TextAreaFigure clone() {
        TextAreaFigure textAreaFigure = (TextAreaFigure)super.clone();
        textAreaFigure.bounds = (Rectangle2D.Double)this.bounds.clone();
        return textAreaFigure;
    }

    @Override
    public TextHolder getLabelFor() {
        return this;
    }

    @Override
    public void restoreTo(Object object) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)object;
        this.bounds.x = double_.x;
        this.bounds.y = double_.y;
        this.bounds.width = double_.width;
        this.bounds.height = double_.height;
    }

    @Override
    public Object getRestoreData() {
        return this.bounds.clone();
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.TEXT_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public void setFontSize(float f) {
        AttributeKeys.FONT_SIZE.set(this, new Double(f));
    }

    @Override
    public float getFontSize() {
        return AttributeKeys.FONT_SIZE.get(this).floatValue();
    }
}

