/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

public abstract class AlignAction
extends AbstractSelectedAction {
    public AlignAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString("align"));
        this.fireUndoableEditHappened(compositeEdit);
        this.alignFigures(this.getView().getSelectedFigures(), this.getSelectionBounds());
        this.fireUndoableEditHappened(compositeEdit);
    }

    protected abstract void alignFigures(Collection var1, Rectangle2D.Double var2);

    protected Rectangle2D.Double getSelectionBounds() {
        Rectangle2D.Double double_ = null;
        for (Figure figure : this.getView().getSelectedFigures()) {
            if (double_ == null) {
                double_ = figure.getBounds();
                continue;
            }
            double_.add(figure.getBounds());
        }
        return double_;
    }

    public static class Horizontal
    extends AlignAction {
        public Horizontal(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignHorizontal");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.x + double_.width / 2.0;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(d - double_2.x - double_2.width / 2.0, 0.0);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }

    public static class Vertical
    extends AlignAction {
        public Vertical(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignVertical");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.y + double_.height / 2.0;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, d - double_2.y - double_2.height / 2.0);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }

    public static class South
    extends AlignAction {
        public South(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignSouth");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.y + double_.height;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, d - double_2.y - double_2.height);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }

    public static class West
    extends AlignAction {
        public West(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignWest");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.x;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(d - double_2.x, 0.0);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }

    public static class East
    extends AlignAction {
        public East(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignEast");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.x + double_.width;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(d - double_2.x - double_2.width, 0.0);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }

    public static class North
    extends AlignAction {
        public North(DrawingEditor drawingEditor) {
            super(drawingEditor);
            this.labels.configureAction(this, "alignNorth");
        }

        protected void alignFigures(Collection collection, Rectangle2D.Double double_) {
            double d = double_.y;
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.willChange();
                Rectangle2D.Double double_2 = figure.getBounds();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, d - double_2.y);
                figure.basicTransform(affineTransform);
                figure.changed();
                this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
            }
        }
    }
}

