/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jhotdraw.draw.action.Colors;

public class ColorIcon
implements Icon {
    private Color fillColor;
    private Color borderColor;

    public ColorIcon(Color color) {
        this.fillColor = color;
        this.borderColor = color == null ? new Color(0, 0, 0, 38) : Colors.shadow(color, 38);
    }

    public int getIconHeight() {
        return 10;
    }

    public int getIconWidth() {
        return 14;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.fillColor == null) {
            graphics.setColor(Color.red);
            graphics.drawLine(n, n2 + this.getIconHeight() - 1, n + this.getIconWidth() - 1, n2);
        } else {
            graphics.setColor(this.fillColor);
            graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
        graphics.setColor(this.borderColor);
        graphics.drawLine(n, n2, n + this.getIconWidth() - 1, n2);
        graphics.drawLine(n + this.getIconWidth() - 1, n2, n + this.getIconWidth() - 1, n2 + this.getIconHeight() - 1);
        graphics.drawLine(n + this.getIconWidth() - 1, n2 + this.getIconHeight() - 1, n, n2 + this.getIconHeight() - 1);
        graphics.drawLine(n, n2 + this.getIconHeight() - 1, n, n2);
    }
}

