/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class PickAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public PickAttributesAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "attributesPick");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.pickAttributes();
    }

    public void pickAttributes() {
        DrawingEditor drawingEditor = this.getEditor();
        Collection<Figure> collection = this.getView().getSelectedFigures();
        if (collection.size() > 0) {
            Figure figure = collection.iterator().next();
            for (Map.Entry<AttributeKey, Object> entry : figure.getAttributes().entrySet()) {
                if (entry.getKey() == AttributeKeys.TEXT) continue;
                drawingEditor.setDefaultAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

