/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractEditorAction;

public class ZoomEditorAction
extends AbstractEditorAction {
    public static final String ID = "zoomEditor";
    private double scaleFactor;
    private AbstractButton button;
    private String label;
    private boolean updateAllViews;

    public ZoomEditorAction(DrawingEditor drawingEditor, double d, AbstractButton abstractButton) {
        this(drawingEditor, d, abstractButton, true);
    }

    public ZoomEditorAction(DrawingEditor drawingEditor, double d, AbstractButton abstractButton, boolean bl) {
        super(drawingEditor);
        this.scaleFactor = d;
        this.button = abstractButton;
        this.updateAllViews = bl;
        this.label = (int)(d * 100.0) + " %";
        this.putValue("Default", this.label);
        this.putValue("Name", this.label);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.button != null) {
            this.button.setText(this.label);
        }
        if (this.updateAllViews) {
            for (DrawingView drawingView : this.getEditor().getDrawingViews()) {
                drawingView.setScaleFactor(this.scaleFactor);
            }
        } else {
            this.getView().setScaleFactor(this.scaleFactor);
        }
    }
}

