/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jhotdraw.geom.Geom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierPath
extends ArrayList<Node>
implements Shape {
    public static final int C1_MASK = 1;
    public static final int C2_MASK = 2;
    public static final int C1C2_MASK = 3;
    private transient GeneralPath generalPath;
    private int outer = -1;
    private boolean isClosed;

    public void add(Point2D.Double double_) {
        this.add(new Node(0, double_, double_, double_));
    }

    public void addPoint(double d, double d2) {
        this.add(new Node(0, d, d2, d, d2, d, d2));
    }

    public void add(int n, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        this.add(new Node(n, double_, double_2, double_3));
    }

    public void set(int n, int n2, Point2D.Double double_) {
        Node node = (Node)this.get(n);
        node.x[n2] = double_.x;
        node.y[n2] = double_.y;
    }

    public Point2D.Double get(int n, int n2) {
        Node node = (Node)this.get(n);
        return new Point2D.Double(node.x[n2], node.y[n2]);
    }

    public void invalidatePath() {
        this.generalPath = null;
        this.outer = -1;
    }

    public void validatePath() {
        if (this.generalPath == null) {
            this.generalPath = this.toGeneralPath();
        }
    }

    public GeneralPath toGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (this.size() == 0) {
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.0f, 1.0f);
        } else if (this.size() == 1) {
            Node node = (Node)this.get(0);
            generalPath.moveTo((float)node.x[0], (float)node.y[0]);
            generalPath.lineTo((float)node.x[0], (float)node.y[0] + 1.0f);
        } else {
            Node node;
            Node node2 = node = (Node)this.get(0);
            generalPath.moveTo((float)node.x[0], (float)node.y[0]);
            int n = this.size();
            for (int i = 1; i < n; ++i) {
                node2 = node;
                node = (Node)this.get(i);
                if ((node2.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        generalPath.lineTo((float)node.x[0], (float)node.y[0]);
                        continue;
                    }
                    generalPath.quadTo((float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                    continue;
                }
                if ((node.mask & 1) == 0) {
                    generalPath.quadTo((float)node2.x[2], (float)node2.y[2], (float)node.x[0], (float)node.y[0]);
                    continue;
                }
                generalPath.curveTo((float)node2.x[2], (float)node2.y[2], (float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
            }
            if (this.isClosed) {
                if (this.size() > 1) {
                    node2 = (Node)this.get(this.size() - 1);
                    node = (Node)this.get(0);
                    if ((node2.mask & 2) == 0) {
                        if ((node.mask & 1) == 0) {
                            generalPath.lineTo((float)node.x[0], (float)node.y[0]);
                        } else {
                            generalPath.quadTo((float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                        }
                    } else if ((node.mask & 1) == 0) {
                        generalPath.quadTo((float)node2.x[2], (float)node2.y[2], (float)node.x[0], (float)node.y[0]);
                    } else {
                        generalPath.curveTo((float)node2.x[2], (float)node2.y[2], (float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                    }
                }
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    @Override
    public boolean contains(Point2D point2D) {
        this.validatePath();
        return this.generalPath.contains(point2D);
    }

    public boolean outlineContains(Point2D.Double double_, double d) {
        this.validatePath();
        PathIterator pathIterator = this.generalPath.getPathIterator(new AffineTransform(), d);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d2 = dArray[0];
        double d3 = dArray[1];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            if (Geom.lineContainsPoint(d2, d3, dArray[0], dArray[1], double_.x, double_.y, d)) {
                return true;
            }
            d2 = dArray[0];
            d3 = dArray[1];
            pathIterator.next();
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        this.validatePath();
        return this.generalPath.intersects(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        this.validatePath();
        return this.generalPath.getPathIterator(affineTransform);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        this.validatePath();
        return this.generalPath.contains(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        this.validatePath();
        return this.generalPath.getPathIterator(affineTransform, d);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        this.validatePath();
        return this.generalPath.intersects(d, d2, d3, d4);
    }

    @Override
    public Rectangle2D getBounds2D() {
        this.validatePath();
        return this.generalPath.getBounds2D();
    }

    public Rectangle2D.Double getBounds2DDouble() {
        this.validatePath();
        Rectangle2D rectangle2D = this.generalPath.getBounds2D();
        if (rectangle2D instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)rectangle2D;
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        this.validatePath();
        return this.generalPath.getBounds();
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        this.validatePath();
        return this.generalPath.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(double d, double d2) {
        this.validatePath();
        return this.generalPath.contains(d, d2);
    }

    public void setClosed(boolean bl) {
        if (this.isClosed != bl) {
            this.isClosed = bl;
            this.invalidatePath();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Object clone() {
        BezierPath bezierPath = (BezierPath)super.clone();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            bezierPath.set(i, (Node)((Node)this.get(i)).clone());
        }
        return bezierPath;
    }

    public void transform(AffineTransform affineTransform) {
        Point2D.Double double_ = new Point2D.Double();
        for (Node node : this) {
            for (int i = 0; i < 3; ++i) {
                double_.x = node.x[i];
                double_.y = node.y[i];
                affineTransform.transform(double_, double_);
                node.x[i] = double_.x;
                node.y[i] = double_.y;
            }
        }
        this.invalidatePath();
    }

    public void setTo(BezierPath bezierPath) {
        while (bezierPath.size() < this.size()) {
            this.remove(this.size() - 1);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.get(i)).setTo((Node)bezierPath.get(i));
        }
        while (this.size() < bezierPath.size()) {
            this.add((Node)((Node)bezierPath.get(this.size())).clone());
        }
    }

    public Point2D.Double getCenter() {
        double d = 0.0;
        double d2 = 0.0;
        for (Node node : this) {
            d += node.x[0];
            d2 += node.y[0];
        }
        int n = this.size();
        return new Point2D.Double(d / (double)n, d2 / (double)n);
    }

    public Point2D.Double chop(Point2D.Double double_) {
        this.validatePath();
        return Geom.chop(this.generalPath, double_);
    }

    public int indexOfOutermostNode() {
        if (this.outer == -1) {
            Point2D.Double double_ = this.getCenter();
            this.outer = 0;
            double d = 0.0;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.get(i);
                double d2 = Geom.length2(double_.x, double_.y, node.x[0], node.y[0]);
                if (!(d2 > d)) continue;
                d = d2;
                this.outer = i;
            }
        }
        return this.outer;
    }

    public Point2D.Double getPointOnPath(double d, double d2) {
        if (this.size() == 0) {
            return null;
        }
        if (this.size() == 1) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (d <= 0.0) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (d >= 1.0) {
            return ((Node)this.get(this.size() - 1)).getControlPoint(0);
        }
        this.validatePath();
        double d3 = 0.0;
        PathIterator pathIterator = this.generalPath.getPathIterator(new AffineTransform(), d2);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d4 = dArray[0];
        double d5 = dArray[1];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            d3 += Geom.length(d4, d5, dArray[0], dArray[1]);
            d4 = dArray[0];
            d5 = dArray[1];
            pathIterator.next();
        }
        double d6 = d3 * d;
        double d7 = 0.0;
        pathIterator = this.generalPath.getPathIterator(new AffineTransform(), d2);
        n = pathIterator.currentSegment(dArray);
        d4 = dArray[0];
        d5 = dArray[1];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            double d8 = Geom.length(d4, d5, dArray[0], dArray[1]);
            if (d7 + d8 >= d6) {
                double d9 = (d6 - d7) / d8;
                return new Point2D.Double(d4 * (1.0 - d9) + dArray[0] * d9, d5 * (1.0 - d9) + dArray[1] * d9);
            }
            d7 += d8;
            d4 = dArray[0];
            d5 = dArray[1];
            pathIterator.next();
        }
        throw new InternalError("We should never get here");
    }

    public int findSegment(Point2D.Double double_, float f) {
        Node node;
        Node node2;
        BezierPath bezierPath = new BezierPath();
        Node node3 = new Node();
        bezierPath.add(node3);
        Node node4 = new Node();
        bezierPath.add(node4);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            node2 = (Node)this.get(i);
            node = (Node)this.get(i + 1);
            if (node2.mask == 0 && node.mask == 0) {
                if (!Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, (double)f)) continue;
                return i;
            }
            node3.setTo(node2);
            node4.setTo(node);
            bezierPath.invalidatePath();
            if (!bezierPath.outlineContains(double_, f)) continue;
            return i;
        }
        if (this.isClosed && this.size() > 1) {
            node2 = (Node)this.get(this.size() - 1);
            node = (Node)this.get(0);
            if (node2.mask == 0 && node.mask == 0) {
                if (Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, (double)f)) {
                    return this.size() - 1;
                }
            } else {
                node3.setTo(node2);
                node4.setTo(node);
                bezierPath.invalidatePath();
                if (bezierPath.outlineContains(double_, f)) {
                    return this.size() - 1;
                }
            }
        }
        return -1;
    }

    public int joinSegments(Point2D.Double double_, float f) {
        for (int i = 0; i < this.size(); ++i) {
            Node node = (Node)this.get(i);
            if (!(Geom.length(node.x[0], node.y[0], double_.x, double_.y) < (double)f)) continue;
            this.remove(i);
            return i;
        }
        return -1;
    }

    public int splitSegment(Point2D.Double double_, float f) {
        int n = this.findSegment(double_, f);
        int n2 = (n + 1) % this.size();
        if (n != -1) {
            if ((((Node)this.get((int)n)).mask & 2) == 2 && (((Node)this.get((int)n2)).mask & 1) == 0) {
                this.add(n + 1, new Node(2, double_, double_, double_));
            } else if ((((Node)this.get((int)n)).mask & 2) == 0 && (((Node)this.get((int)n2)).mask & 1) == 1) {
                this.add(n + 1, new Node(2, double_, double_, double_));
            } else if ((((Node)this.get((int)n)).mask & 2) == 2 && (((Node)this.get((int)n2)).mask & 1) == 2) {
                this.add(n + 1, new Node(3, double_, double_, double_));
            } else {
                this.add(n + 1, new Node(double_));
            }
        }
        return n + 1;
    }

    public void moveTo(double d, double d2) {
        if (this.size() != 0) {
            throw new IllegalPathStateException("moveTo only allowed when empty");
        }
        this.add(new Node(d, d2));
    }

    public void lineTo(double d, double d2) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("lineTo only allowed when not empty");
        }
        this.add(new Node(d, d2));
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("quadTo only allowed when not empty");
        }
        this.add(new Node(1, d3, d4, d, d2, d3, d4));
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("curveTo only allowed when not empty");
        }
        Node node = (Node)this.get(this.size() - 1);
        node.mask |= 2;
        node.x[2] = d;
        node.y[2] = d2;
        this.add(new Node(1, d5, d6, d3, d4, d5, d6));
    }

    public Point2D.Double[] toPolygonArray() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = new Point2D.Double(((Node)this.get((int)i)).x[0], ((Node)this.get((int)i)).y[0]);
        }
        return doubleArray;
    }

    public static class Node
    implements Cloneable {
        public int mask = 0;
        public double[] x = new double[3];
        public double[] y = new double[3];
        public boolean keepColinear = true;

        public Node() {
            this.mask = 1;
        }

        public Node(Node node) {
            this.setTo(node);
        }

        public void setTo(Node node) {
            this.mask = node.mask;
            this.keepColinear = node.keepColinear;
            System.arraycopy(node.x, 0, this.x, 0, 3);
            System.arraycopy(node.y, 0, this.y, 0, 3);
        }

        public Node(Point2D.Double double_) {
            this.mask = 0;
            this.x[0] = double_.x;
            this.y[0] = double_.y;
            this.x[1] = double_.x;
            this.y[1] = double_.y;
            this.x[2] = double_.x;
            this.y[2] = double_.y;
        }

        public Node(int n, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
            this.mask = n;
            this.x[0] = double_.x;
            this.y[0] = double_.y;
            this.x[1] = double_2.x;
            this.y[1] = double_2.y;
            this.x[2] = double_3.x;
            this.y[2] = double_3.y;
        }

        public Node(double d, double d2) {
            this.mask = 0;
            this.x[0] = d;
            this.y[0] = d2;
            this.x[1] = d;
            this.y[1] = d2;
            this.x[2] = d;
            this.y[2] = d2;
        }

        public Node(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            this.mask = n;
            this.x[0] = d;
            this.y[0] = d2;
            this.x[1] = d3;
            this.y[1] = d4;
            this.x[2] = d5;
            this.y[2] = d6;
        }

        public int getMask() {
            return this.mask;
        }

        public void setMask(int n) {
            this.mask = n;
        }

        public void setControlPoint(int n, Point2D.Double double_) {
            this.x[n] = double_.x;
            this.y[n] = double_.y;
        }

        public Point2D.Double getControlPoint(int n) {
            return new Point2D.Double(this.x[n], this.y[n]);
        }

        public void moveTo(Point2D.Double double_) {
            this.moveBy(double_.x - this.x[0], double_.y - this.y[0]);
        }

        public void moveTo(double d, double d2) {
            this.moveBy(d - this.x[0], d2 - this.y[0]);
        }

        public void moveBy(double d, double d2) {
            int n = 0;
            while (n < 3) {
                int n2 = n;
                this.x[n2] = this.x[n2] + d;
                int n3 = n++;
                this.y[n3] = this.y[n3] + d2;
            }
        }

        public Object clone() {
            try {
                Node node = (Node)super.clone();
                node.x = (double[])this.x.clone();
                node.y = (double[])this.y.clone();
                return node;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                InternalError internalError = new InternalError();
                internalError.initCause(cloneNotSupportedException);
                throw internalError;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    if ((this.mask & i) != i) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append('x');
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(this.x[i]);
                stringBuilder.append(",y");
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(this.y[i]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

