/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Geom {
    public static final int OUT_TOP = 2;
    public static final int OUT_BOTTOM = 8;
    public static final int OUT_LEFT = 1;
    public static final int OUT_RIGHT = 4;

    private Geom() {
    }

    public static boolean lineContainsPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        return Geom.lineContainsPoint(n, n2, n3, n4, n5, n6, 3.0);
    }

    public static boolean lineContainsPoint(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        Rectangle rectangle = new Rectangle(new Point(n, n2));
        rectangle.add(n3, n4);
        rectangle.grow(Math.max(2, (int)Math.ceil(d)), Math.max(2, (int)Math.ceil(d)));
        if (!rectangle.contains(n5, n6)) {
            return false;
        }
        if (n == n3) {
            return (double)Math.abs(n5 - n) <= d;
        }
        if (n2 == n4) {
            return (double)Math.abs(n6 - n2) <= d;
        }
        double d2 = (double)(n2 - n4) / (double)(n - n3);
        double d3 = (double)n2 - d2 * (double)n;
        double d4 = ((double)n6 - d3) / d2;
        double d5 = d2 * (double)n5 + d3;
        return Math.min(Math.abs(d4 - (double)n5), Math.abs(d5 - (double)n6)) <= d;
    }

    public static boolean lineContainsPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, 0.0, 0.0);
        double_.add(d3, d4);
        double d8 = Math.max(2, (int)Math.ceil(d7));
        double_.x -= d8;
        double_.y -= d8;
        double_.width += d8 * 2.0;
        double_.height += d8 * 2.0;
        if (!double_.contains(d5, d6)) {
            return false;
        }
        if (d == d3) {
            return Math.abs(d5 - d) <= d7;
        }
        if (d2 == d4) {
            return Math.abs(d6 - d2) <= d7;
        }
        double d9 = (d2 - d4) / (d - d3);
        double d10 = d2 - d9 * d;
        double d11 = (d6 - d10) / d9;
        double d12 = d9 * d5 + d10;
        return Math.min(Math.abs(d11 - d5), Math.abs(d12 - d6)) <= d7;
    }

    public static int direction(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n4 - n2;
        int n7 = n3 - n;
        n5 = n6 < n7 && n7 > -n6 ? 4 : (n6 > n7 && n6 > -n7 ? 2 : (n7 < n6 && n7 < -n6 ? 1 : 8));
        return n5;
    }

    public static int direction(double d, double d2, double d3, double d4) {
        int n = 0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        n = d5 < d6 && d6 > -d5 ? 4 : (d5 > d6 && d5 > -d6 ? 2 : (d6 < d5 && d6 < -d5 ? 1 : 8));
        return n;
    }

    public static int outcode(Rectangle rectangle, Rectangle rectangle2) {
        int n = 0;
        if (rectangle2.x > rectangle.x + rectangle.width) {
            n = 4;
        } else if (rectangle2.x + rectangle2.width < rectangle.x) {
            n = 1;
        }
        if (rectangle2.y > rectangle.y + rectangle.height) {
            n |= 8;
        } else if (rectangle2.y + rectangle2.height < rectangle.y) {
            n |= 2;
        }
        return n;
    }

    public static int outcode(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        int n = 0;
        if (double_2.x > double_.x + double_.width) {
            n = 4;
        } else if (double_2.x + double_2.width < double_.x) {
            n = 1;
        }
        if (double_2.y > double_.y + double_.height) {
            n |= 8;
        } else if (double_2.y + double_2.height < double_.y) {
            n |= 2;
        }
        return n;
    }

    public static Point south(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
    }

    public static Point2D.Double south(Rectangle2D.Double double_) {
        return new Point2D.Double(double_.x + double_.width / 2.0, double_.y + double_.height);
    }

    public static Point center(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Point2D.Double center(Rectangle2D.Double double_) {
        return new Point2D.Double(double_.x + double_.width / 2.0, double_.y + double_.height / 2.0);
    }

    public static Point2D.Double chop(Shape shape, Point2D.Double double_) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Point2D.Double double_2 = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        double d = -1.0;
        double d2 = -1.0;
        double d3 = Double.MAX_VALUE;
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform(), 1.0);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = d4;
        double d7 = d5;
        pathIterator.next();
        while (!pathIterator.isDone()) {
            double d8;
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d6 = dArray[0];
                    d7 = dArray[1];
                    break;
                }
                case 4: {
                    dArray[0] = d6;
                    dArray[1] = d7;
                }
            }
            Point2D.Double double_3 = Geom.intersect(d4, d5, dArray[0], dArray[1], double_.x, double_.y, double_2.x, double_2.y);
            if (double_3 != null && (d8 = Geom.length2(double_3.x, double_3.y, double_.x, double_.y)) < d3) {
                d3 = d8;
                d = double_3.x;
                d2 = double_3.y;
            }
            d4 = dArray[0];
            d5 = dArray[1];
            pathIterator.next();
        }
        if (d3 == Double.MAX_VALUE) {
            pathIterator = shape.getPathIterator(new AffineTransform(), 1.0);
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(dArray);
                double d9 = Geom.length2(double_2.x, double_2.y, dArray[0], dArray[1]);
                if (d9 < d3) {
                    d3 = d9;
                    d = dArray[0];
                    d2 = dArray[1];
                }
                pathIterator.next();
            }
        }
        return new Point2D.Double(d, d2);
    }

    public static Point west(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y + rectangle.height / 2);
    }

    public static Point2D.Double west(Rectangle2D.Double double_) {
        return new Point2D.Double(double_.x, double_.y + double_.height / 2.0);
    }

    public static Point east(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
    }

    public static Point2D.Double east(Rectangle2D.Double double_) {
        return new Point2D.Double(double_.x + double_.width, double_.y + double_.height / 2.0);
    }

    public static Point north(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y);
    }

    public static Point2D.Double north(Rectangle2D.Double double_) {
        return new Point2D.Double(double_.x + double_.width / 2.0, double_.y);
    }

    public static int range(int n, int n2, int n3) {
        if (n3 < n) {
            n3 = n;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static double range(double d, double d2, double d3) {
        if (d3 < d) {
            d3 = d;
        }
        if (d3 > d2) {
            d3 = d2;
        }
        return d3;
    }

    public static long length2(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    public static long length(int n, int n2, int n3, int n4) {
        return (long)Math.sqrt(Geom.length2(n, n2, n3, n4));
    }

    public static double length2(double d, double d2, double d3, double d4) {
        return (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
    }

    public static double length(double d, double d2, double d3, double d4) {
        return Math.sqrt(Geom.length2(d, d2, d3, d4));
    }

    public static double length(Point2D.Double double_, Point2D.Double double_2) {
        return Math.sqrt(Geom.length2(double_.x, double_.y, double_2.x, double_2.y));
    }

    public static Point2D.Double cap(Point2D.Double double_, Point2D.Double double_2, double d) {
        double d2 = 1.5707963267948966 - Math.atan2(double_2.x - double_.x, double_2.y - double_.y);
        Point2D.Double double_3 = new Point2D.Double(double_2.x + d * Math.cos(d2), double_2.y + d * Math.sin(d2));
        return double_3;
    }

    public static double pointToAngle(Rectangle rectangle, Point point) {
        int n = point.x - (rectangle.x + rectangle.width / 2);
        int n2 = point.y - (rectangle.y + rectangle.height / 2);
        return Math.atan2(n2 * rectangle.width, n * rectangle.height);
    }

    public static double pointToAngle(Rectangle2D.Double double_, Point2D.Double double_2) {
        double d = double_2.x - (double_.x + double_.width / 2.0);
        double d2 = double_2.y - (double_.y + double_.height / 2.0);
        return Math.atan2(d2 * double_.width, d * double_.height);
    }

    public static double angle(double d, double d2, double d3, double d4) {
        return Math.atan2(d4 - d2, d3 - d);
    }

    public static Point angleToPoint(Rectangle rectangle, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0E-4;
        int n = 0;
        int n2 = 0;
        if (Math.abs(d2) > d4) {
            n = (int)((1.0 + d3 / Math.abs(d2)) / 2.0 * (double)rectangle.width);
            n = Geom.range(0, rectangle.width, n);
        } else if (d3 >= 0.0) {
            n = rectangle.width;
        }
        if (Math.abs(d3) > d4) {
            n2 = (int)((1.0 + d2 / Math.abs(d3)) / 2.0 * (double)rectangle.height);
            n2 = Geom.range(0, rectangle.height, n2);
        } else if (d2 >= 0.0) {
            n2 = rectangle.height;
        }
        return new Point(rectangle.x + n, rectangle.y + n2);
    }

    public static Point2D.Double angleToPoint(Rectangle2D.Double double_, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0E-4;
        double d5 = 0.0;
        double d6 = 0.0;
        if (Math.abs(d2) > d4) {
            d5 = (1.0 + d3 / Math.abs(d2)) / 2.0 * double_.width;
            d5 = Geom.range(0.0, double_.width, d5);
        } else if (d3 >= 0.0) {
            d5 = double_.width;
        }
        if (Math.abs(d3) > d4) {
            d6 = (1.0 + d2 / Math.abs(d3)) / 2.0 * double_.height;
            d6 = Geom.range(0.0, double_.height, d6);
        } else if (d2 >= 0.0) {
            d6 = double_.height;
        }
        return new Point2D.Double(double_.x + d5, double_.y + d6);
    }

    public static Point polarToPoint(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        return new Point((int)(d2 * d5 + 0.5), (int)(d3 * d4 + 0.5));
    }

    public static Point2D.Double polarToPoint2D(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        return new Point2D.Double(d2 * d5 + 0.5, d3 * d4 + 0.5);
    }

    public static Point ovalAngleToPoint(Rectangle rectangle, double d) {
        Point point = Geom.center(rectangle);
        Point point2 = Geom.polarToPoint(d, rectangle.width / 2, rectangle.height / 2);
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public static Point2D.Double ovalAngleToPoint(Rectangle2D.Double double_, double d) {
        Point2D.Double double_2 = Geom.center(double_);
        Point2D.Double double_3 = Geom.polarToPoint2D(d, double_.width / 2.0, double_.height / 2.0);
        return new Point2D.Double(double_2.x + double_3.x, double_2.y + double_3.y);
    }

    public static Point intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double d = (n3 - n) * (n8 - n6) - (n4 - n2) * (n7 - n5);
        double d2 = (n2 - n6) * (n7 - n5) - (n - n5) * (n8 - n6);
        if (d == 0.0) {
            if (d2 == 0.0) {
                if (n < n3 && (n3 < n5 || n3 < n7) || n > n3 && (n3 > n5 || n3 > n7)) {
                    return new Point(n3, n4);
                }
                return new Point(n, n2);
            }
            return null;
        }
        double d3 = d2 / d;
        double d4 = (n2 - n6) * (n3 - n) - (n - n5) * (n4 - n2);
        double d5 = d4 / d;
        if (0.0 <= d3 && d3 <= 1.0 && 0.0 <= d5 && d5 <= 1.0) {
            int n9 = (int)((double)n + (double)(n3 - n) * d3);
            int n10 = (int)((double)n2 + (double)(n4 - n2) * d3);
            return new Point(n9, n10);
        }
        return null;
    }

    public static Point2D.Double intersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d3 - d) * (d8 - d6) - (d4 - d2) * (d7 - d5);
        double d10 = (d2 - d6) * (d7 - d5) - (d - d5) * (d8 - d6);
        if (d9 == 0.0) {
            if (d10 == 0.0) {
                if (d < d3 && (d3 < d5 || d3 < d7) || d > d3 && (d3 > d5 || d3 > d7)) {
                    return new Point2D.Double(d3, d4);
                }
                return new Point2D.Double(d, d2);
            }
            return null;
        }
        double d11 = d10 / d9;
        double d12 = (d2 - d6) * (d3 - d) - (d - d5) * (d4 - d2);
        double d13 = d12 / d9;
        if (0.0 <= d11 && d11 <= 1.0 && 0.0 <= d13 && d13 <= 1.0) {
            double d14 = d + (d3 - d) * d11;
            double d15 = d2 + (d4 - d2) * d11;
            return new Point2D.Double(d14, d15);
        }
        return null;
    }

    public static Point2D.Double intersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d3 - d) * (d8 - d6) - (d4 - d2) * (d7 - d5);
        double d11 = (d2 - d6) * (d7 - d5) - (d - d5) * (d8 - d6);
        if (d10 == 0.0) {
            if (d11 == 0.0) {
                if (d < d3 && (d3 < d5 || d3 < d7) || d > d3 && (d3 > d5 || d3 > d7)) {
                    return new Point2D.Double(d3, d4);
                }
                return new Point2D.Double(d, d2);
            }
            return null;
        }
        double d12 = d11 / d10;
        double d13 = (d2 - d6) * (d3 - d) - (d - d5) * (d4 - d2);
        double d14 = d13 / d10;
        if (0.0 <= d12 && d12 <= 1.0 && 0.0 <= d14 && d14 <= 1.0) {
            double d15 = d + (d3 - d) * d12;
            double d16 = d2 + (d4 - d2) * d12;
            return new Point2D.Double(d15, d16);
        }
        double d17 = d + (d3 - d) * d12;
        double d18 = d2 + (d4 - d2) * d12;
        if (Geom.length(d, d2, d17, d18) <= d9 || Geom.length(d3, d4, d17, d18) <= d9 || Geom.length(d5, d6, d17, d18) <= d9 || Geom.length(d7, d8, d17, d18) <= d9) {
            return new Point2D.Double(d17, d18);
        }
        return null;
    }

    public static double distanceFromLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        long l = n7 * n7 + n8 * n8;
        if (l == 0L) {
            return Geom.length(n, n2, n5, n6);
        }
        double d = (n2 - n6) * (n2 - n4) - (n - n5) * (n3 - n);
        double d2 = d / (double)l;
        if (d2 < 0.0 || d2 > 1.0) {
            return Double.MAX_VALUE;
        }
        double d3 = (double)n + d2 * (double)n7;
        double d4 = (double)n2 + d2 * (double)n8;
        double d5 = (double)n5 - d3;
        double d6 = (double)n6 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static void grow(Rectangle2D.Double double_, double d, double d2) {
        double_.x -= d;
        double_.y -= d2;
        double_.width += d * 2.0;
        double_.height += d2 * 2.0;
    }
}

