/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionTool;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.JPopupButton;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.ToolBarButtonFactory;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.samples.pert.figures.DependencyFigure;
import org.jhotdraw.samples.pert.figures.TaskFigure;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class PertPanel
extends JPanel {
    private UndoRedoManager undoManager;
    private Drawing drawing;
    private DrawingEditor editor;
    private JToolBar attributesToolbar;
    private JToolBar creationToolbar;
    private JPanel jPanel1;
    private JScrollPane scrollPane;
    private ButtonGroup toolButtonGroup;
    private DefaultDrawingView view;

    public PertPanel() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.initComponents();
        this.undoManager = new UndoRedoManager();
        this.editor = new DefaultDrawingEditor();
        this.editor.add(this.view);
        this.addCreationButtonsTo(this.creationToolbar, this.editor);
        ToolBarButtonFactory.addAttributesButtonsTo(this.attributesToolbar, this.editor);
        JPopupButton jPopupButton = new JPopupButton();
        jPopupButton.setItemFont(UIManager.getFont("MenuItem.font"));
        resourceBundleUtil.configureToolBarButton(jPopupButton, "actions");
        jPopupButton.add(new DuplicateAction());
        jPopupButton.addSeparator();
        jPopupButton.add(new GroupAction(this.editor));
        jPopupButton.add(new UngroupAction(this.editor));
        jPopupButton.addSeparator();
        jPopupButton.add(new MoveToFrontAction(this.editor));
        jPopupButton.add(new MoveToBackAction(this.editor));
        jPopupButton.addSeparator();
        jPopupButton.add(new CutAction());
        jPopupButton.add(new CopyAction());
        jPopupButton.add(new PasteAction());
        jPopupButton.add(new SelectAllAction());
        jPopupButton.add(new SelectSameAction(this.editor));
        jPopupButton.addSeparator();
        jPopupButton.add(this.undoManager.getUndoAction());
        jPopupButton.add(this.undoManager.getRedoAction());
        jPopupButton.addSeparator();
        jPopupButton.add(new ToggleGridAction(this.editor));
        JMenu jMenu = new JMenu(resourceBundleUtil.getString("zoom"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.1, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.25, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.5, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.75, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.0, null));
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.25, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.5, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 2.0, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 3.0, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(new ZoomAction(this.editor, 4.0, null));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jPopupButton.add(jMenu);
        jPopupButton.setFocusable(false);
        this.creationToolbar.addSeparator();
        this.creationToolbar.add(jPopupButton);
        DefaultDrawing defaultDrawing = new DefaultDrawing();
        this.view.setDrawing(defaultDrawing);
        defaultDrawing.addUndoableEditListener(this.undoManager);
    }

    public void setDrawing(Drawing drawing) {
        this.undoManager.discardAllEdits();
        this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.jPanel1 = new JPanel();
        this.creationToolbar = new JToolBar();
        this.attributesToolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.creationToolbar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.creationToolbar, gridBagConstraints);
        this.attributesToolbar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.attributesToolbar, gridBagConstraints);
        this.add((Component)this.jPanel1, "South");
    }

    private void addCreationButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.pert.Labels");
        ResourceBundleUtil resourceBundleUtil2 = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ToolBarButtonFactory.addSelectionToolTo(jToolBar, drawingEditor);
        jToolBar.addSeparator();
        HashMap<AttributeKey<Object>, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.FILL_COLOR, Color.white);
        hashMap.put(AttributeKeys.STROKE_COLOR, Color.black);
        hashMap.put(AttributeKeys.TEXT_COLOR, Color.black);
        ToolBarButtonFactory.addToolTo(jToolBar, drawingEditor, new CreationTool(new TaskFigure(), hashMap), "createTask", resourceBundleUtil);
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_COLOR, new Color(153));
        ToolBarButtonFactory.addToolTo(jToolBar, drawingEditor, new ConnectionTool(new DependencyFigure(), hashMap), "createDependency", resourceBundleUtil);
        jToolBar.addSeparator();
        ToolBarButtonFactory.addToolTo(jToolBar, drawingEditor, new TextAreaTool(new TextAreaFigure()), "createTextArea", resourceBundleUtil2);
    }
}

