/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert.figures;

import java.awt.Color;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.samples.pert.figures.TaskFigure;

public class DependencyFigure
extends LineConnectionFigure {
    public DependencyFigure() {
        AttributeKeys.STROKE_COLOR.set(this, new Color(153));
        AttributeKeys.STROKE_WIDTH.set(this, 1.0);
        AttributeKeys.END_DECORATION.set(this, new ArrowTip());
        this.setAttributeEnabled(AttributeKeys.END_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.START_DECORATION, false);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        this.setAttributeEnabled(AttributeKeys.FONT_ITALIC, false);
        this.setAttributeEnabled(AttributeKeys.FONT_UNDERLINED, false);
    }

    public boolean canConnect(Figure figure, Figure figure2) {
        if (figure instanceof TaskFigure && figure2 instanceof TaskFigure) {
            TaskFigure taskFigure = (TaskFigure)figure;
            TaskFigure taskFigure2 = (TaskFigure)figure2;
            if (taskFigure2.getPredecessors().contains(taskFigure)) {
                return false;
            }
            return !taskFigure.isDependentOf(taskFigure2);
        }
        return false;
    }

    public boolean canConnect(Figure figure) {
        return figure instanceof TaskFigure;
    }

    protected void handleDisconnect(Figure figure, Figure figure2) {
        TaskFigure taskFigure = (TaskFigure)figure;
        TaskFigure taskFigure2 = (TaskFigure)figure2;
        taskFigure.removeDependency(this);
        taskFigure2.removeDependency(this);
    }

    protected void handleConnect(Figure figure, Figure figure2) {
        TaskFigure taskFigure = (TaskFigure)figure;
        TaskFigure taskFigure2 = (TaskFigure)figure2;
        taskFigure.addDependency(this);
        taskFigure2.addDependency(this);
    }

    public DependencyFigure clone() {
        DependencyFigure dependencyFigure = (DependencyFigure)super.clone();
        return dependencyFigure;
    }

    public int getLayer() {
        return 1;
    }

    public void removeNotify(Drawing drawing) {
        if (this.getStartFigure() != null) {
            ((TaskFigure)this.getStartFigure()).removeDependency(this);
        }
        if (this.getEndFigure() != null) {
            ((TaskFigure)this.getEndFigure()).removeDependency(this);
        }
        super.removeNotify(drawing);
    }
}

