/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert.figures;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AbstractFigureListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ConnectionHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.GraphicalCompositeFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ListFigure;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.VerticalLayouter;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.samples.pert.figures.DependencyFigure;
import org.jhotdraw.samples.pert.figures.SeparatorLineFigure;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFigure
extends GraphicalCompositeFigure {
    private HashSet<DependencyFigure> dependencies;
    private int startTime;

    public TaskFigure() {
        super(new RectangleFigure());
        this.setLayouter(new VerticalLayouter());
        RectangleFigure rectangleFigure = new RectangleFigure();
        AttributeKeys.STROKE_COLOR.set(rectangleFigure, null);
        rectangleFigure.setAttributeEnabled(AttributeKeys.STROKE_COLOR, false);
        AttributeKeys.FILL_COLOR.set(rectangleFigure, null);
        rectangleFigure.setAttributeEnabled(AttributeKeys.FILL_COLOR, false);
        ListFigure listFigure = new ListFigure(rectangleFigure);
        ListFigure listFigure2 = new ListFigure();
        SeparatorLineFigure separatorLineFigure = new SeparatorLineFigure();
        this.applyAttributes(this.getPresentationFigure());
        this.add(listFigure);
        this.add(separatorLineFigure);
        this.add(listFigure2);
        Insets2DDouble insets2DDouble = new Insets2DDouble(4.0, 8.0, 4.0, 8.0);
        LAYOUT_INSETS.set(listFigure, insets2DDouble);
        LAYOUT_INSETS.set(listFigure2, insets2DDouble);
        TextFigure textFigure = new TextFigure();
        listFigure.add(textFigure);
        AttributeKeys.FONT_BOLD.set(textFigure, true);
        textFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure textFigure2 = new TextFigure();
        listFigure2.add(textFigure2);
        AttributeKeys.FONT_BOLD.set(textFigure2, true);
        textFigure2.setText("0");
        textFigure2.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure textFigure3 = new TextFigure();
        listFigure2.add(textFigure3);
        textFigure3.setEditable(false);
        textFigure3.setText("0");
        textFigure3.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        this.applyAttributes(this);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.pert.Labels");
        this.setName(resourceBundleUtil.getString("taskDefaultName"));
        this.setDuration(0);
        this.startTime = 0;
        this.dependencies = new HashSet();
        textFigure.addFigureListener(new NameAdapter(this));
        textFigure2.addFigureListener(new DurationAdapter(this));
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            linkedList.add(new MoveHandle(this, RelativeLocator.northWest()));
            linkedList.add(new MoveHandle(this, RelativeLocator.northEast()));
            linkedList.add(new MoveHandle(this, RelativeLocator.southWest()));
            linkedList.add(new MoveHandle(this, RelativeLocator.southEast()));
            linkedList.add(new ConnectionHandle(this, RelativeLocator.east(), new DependencyFigure()));
        }
        return linkedList;
    }

    public void setName(String string) {
        this.getNameFigure().setText(string);
    }

    public String getName() {
        return this.getNameFigure().getText();
    }

    public void setDuration(int n) {
        int n2 = this.getDuration();
        this.getDurationFigure().setText(Integer.toString(n));
        if (n2 != n) {
            for (TaskFigure taskFigure : this.getSuccessors()) {
                taskFigure.updateStartTime();
            }
        }
    }

    public int getDuration() {
        try {
            return Integer.valueOf(this.getDurationFigure().getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void updateStartTime() {
        int n = this.getStartTime();
        int n2 = 0;
        for (TaskFigure taskFigure : this.getPredecessors()) {
            n2 = Math.max(n2, taskFigure.getStartTime() + taskFigure.getDuration());
        }
        this.getStartTimeFigure().setText(Integer.toString(n2));
        if (n2 != n) {
            for (TaskFigure taskFigure : this.getSuccessors()) {
                if (this.isDependentOf(taskFigure)) continue;
                taskFigure.updateStartTime();
            }
        }
        if (n != n2) {
            this.fireAreaInvalidated();
        }
    }

    public int getStartTime() {
        try {
            return Integer.valueOf(this.getStartTimeFigure().getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private TextFigure getNameFigure() {
        return (TextFigure)((ListFigure)this.getChild(0)).getChild(0);
    }

    private TextFigure getDurationFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(0);
    }

    private TextFigure getStartTimeFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(1);
    }

    private void applyAttributes(Figure figure) {
        Map<AttributeKey, Object> map = ((AttributedFigure)this.getPresentationFigure()).getAttributes();
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            figure.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public TaskFigure clone() {
        TaskFigure taskFigure = (TaskFigure)super.clone();
        taskFigure.dependencies = new HashSet();
        taskFigure.getNameFigure().addFigureListener(new NameAdapter(taskFigure));
        taskFigure.getDurationFigure().addFigureListener(new DurationAdapter(taskFigure));
        taskFigure.updateStartTime();
        return taskFigure;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        double d = dOMInput.getAttribute("x", 0.0);
        double d2 = dOMInput.getAttribute("y", 0.0);
        double d3 = dOMInput.getAttribute("w", 0.0);
        double d4 = dOMInput.getAttribute("h", 0.0);
        this.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
        this.readAttributes(dOMInput);
        dOMInput.openElement("model");
        dOMInput.openElement("name");
        this.setName((String)dOMInput.readObject());
        dOMInput.closeElement();
        dOMInput.openElement("duration");
        this.setDuration((Integer)dOMInput.readObject());
        dOMInput.closeElement();
        dOMInput.closeElement();
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        Rectangle2D.Double double_ = this.getBounds();
        dOMOutput.addAttribute("x", double_.x);
        dOMOutput.addAttribute("y", double_.y);
        this.writeAttributes(dOMOutput);
        dOMOutput.openElement("model");
        dOMOutput.openElement("name");
        dOMOutput.writeObject(this.getName());
        dOMOutput.closeElement();
        dOMOutput.openElement("duration");
        dOMOutput.writeObject(this.getDuration());
        dOMOutput.closeElement();
        dOMOutput.closeElement();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    public Set<DependencyFigure> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public void addDependency(DependencyFigure dependencyFigure) {
        this.dependencies.add(dependencyFigure);
        this.updateStartTime();
    }

    public void removeDependency(DependencyFigure dependencyFigure) {
        this.dependencies.remove(dependencyFigure);
        this.updateStartTime();
    }

    public List<TaskFigure> getSuccessors() {
        LinkedList<TaskFigure> linkedList = new LinkedList<TaskFigure>();
        for (DependencyFigure dependencyFigure : this.getDependencies()) {
            if (dependencyFigure.getStartFigure() != this) continue;
            linkedList.add((TaskFigure)dependencyFigure.getEndFigure());
        }
        return linkedList;
    }

    public List<TaskFigure> getPredecessors() {
        LinkedList<TaskFigure> linkedList = new LinkedList<TaskFigure>();
        for (DependencyFigure dependencyFigure : this.getDependencies()) {
            if (dependencyFigure.getEndFigure() != this) continue;
            linkedList.add((TaskFigure)dependencyFigure.getStartFigure());
        }
        return linkedList;
    }

    public boolean isDependentOf(TaskFigure taskFigure) {
        if (this == taskFigure) {
            return true;
        }
        for (TaskFigure taskFigure2 : this.getPredecessors()) {
            if (!taskFigure2.isDependentOf(taskFigure)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "TaskFigure#" + this.hashCode() + " " + this.getName() + " " + this.getDuration() + " " + this.getStartTime();
    }

    private static class DurationAdapter
    extends AbstractFigureListener {
        private TaskFigure target;

        public DurationAdapter(TaskFigure taskFigure) {
            this.target = taskFigure;
        }

        public void figureAttributeChanged(FigureEvent figureEvent) {
            for (TaskFigure taskFigure : this.target.getSuccessors()) {
                taskFigure.updateStartTime();
            }
        }
    }

    private static class NameAdapter
    extends AbstractFigureListener {
        private TaskFigure target;

        public NameAdapter(TaskFigure taskFigure) {
            this.target = taskFigure;
        }

        public void figureAttributeChanged(FigureEvent figureEvent) {
        }
    }
}

