/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;
import nanoxml.XMLElement;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class NanoXMLLiteDOMOutput
implements DOMOutput {
    private String doctype;
    private HashMap<Object, String> objectids;
    private HashMap<String, Object> prototypes;
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack;

    public NanoXMLLiteDOMOutput(DOMFactory dOMFactory) {
        this.factory = dOMFactory;
        this.objectids = new HashMap();
        this.current = this.document = new XMLElement(new HashMap(), false, false);
        this.stack = new Stack();
        this.stack.push(this.current);
    }

    public void save(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        this.save(outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    public void save(Writer writer) throws IOException {
        if (this.doctype != null) {
            writer.write("<!DOCTYPE ");
            writer.write(this.doctype);
            writer.write(">\n");
        }
        ((XMLElement)this.document.getChildren().get(0)).write(writer);
    }

    public void print(PrintWriter printWriter) {
        ((XMLElement)this.document.getChildren().get(0)).print(printWriter);
    }

    public void openElement(String string) {
        XMLElement xMLElement = new XMLElement(new HashMap(), false, false);
        xMLElement.setName(string);
        this.current.addChild(xMLElement);
        this.stack.push(this.current);
        this.current = xMLElement;
    }

    public void closeElement() {
        this.current = this.stack.pop();
    }

    public void addComment(String string) {
    }

    public void addText(String string) {
        String string2 = this.current.getContent();
        if (string2 == null) {
            this.current.setContent(string);
        } else {
            this.current.setContent(string2 + string);
        }
    }

    public void addAttribute(String string, String string2) {
        if (string2 != null) {
            this.current.setAttribute(string, string2);
        }
    }

    public void addAttribute(String string, int n) {
        this.current.setAttribute(string, Integer.toString(n));
    }

    public void addAttribute(String string, boolean bl) {
        this.current.setAttribute(string, new Boolean(bl).toString());
    }

    public void addAttribute(String string, float f) {
        String string2 = Float.toString(f);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.current.setAttribute(string, string2);
    }

    public void addAttribute(String string, double d) {
        String string2 = Double.toString(d);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        this.current.setAttribute(string, string2);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.openElement("null");
            this.closeElement();
        } else if (object instanceof DOMStorable) {
            this.writeStorable((DOMStorable)object);
        } else if (object instanceof String) {
            this.openElement("string");
            this.addText((String)object);
            this.closeElement();
        } else if (object instanceof Integer) {
            this.openElement("int");
            this.addText(object.toString());
            this.closeElement();
        } else if (object instanceof Long) {
            this.openElement("long");
            this.addText(object.toString());
            this.closeElement();
        } else if (object instanceof Double) {
            this.openElement("double");
            String string = object.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            this.addText(string);
            this.closeElement();
        } else if (object instanceof Float) {
            this.openElement("float");
            String string = object.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            this.addText(string);
            this.closeElement();
        } else if (object instanceof Boolean) {
            this.openElement("boolean");
            this.addText(object.toString());
            this.closeElement();
        } else if (object instanceof Color) {
            Color color = (Color)object;
            this.openElement("color");
            this.addAttribute("rgba", "#" + Integer.toHexString(color.getRGB()));
            this.closeElement();
        } else if (object instanceof int[]) {
            this.openElement("intArray");
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                this.writeObject(new Integer(nArray[i]));
            }
            this.closeElement();
        } else if (object instanceof float[]) {
            this.openElement("floatArray");
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                this.writeObject(new Float(fArray[i]));
            }
            this.closeElement();
        } else if (object instanceof double[]) {
            this.openElement("doubleArray");
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                this.writeObject(new Double(dArray[i]));
            }
            this.closeElement();
        } else if (object instanceof Font) {
            Font font = (Font)object;
            this.openElement("font");
            this.addAttribute("name", font.getName());
            this.addAttribute("style", font.getStyle());
            this.addAttribute("size", font.getSize());
            this.closeElement();
        } else if (object instanceof Enum) {
            this.openElement("enum");
            Enum enum_ = (Enum)object;
            this.addAttribute("type", this.factory.getEnumName(enum_));
            this.addText(this.factory.getEnumValue(enum_));
            this.closeElement();
        } else {
            throw new IllegalArgumentException("unable to store: " + object + " " + object.getClass());
        }
    }

    private XMLElement writeStorable(DOMStorable dOMStorable) throws IOException {
        String string = this.factory.getName(dOMStorable);
        if (string == null) {
            throw new IllegalArgumentException("no tag name for:" + dOMStorable);
        }
        this.openElement(string);
        XMLElement xMLElement = this.current;
        if (this.objectids.containsKey(dOMStorable)) {
            this.addAttribute("ref", this.objectids.get(dOMStorable));
        } else {
            String string2 = Integer.toString(this.objectids.size(), 16);
            this.objectids.put(dOMStorable, string2);
            this.addAttribute("id", string2);
            dOMStorable.write(this);
        }
        this.closeElement();
        return xMLElement;
    }

    public void addAttribute(String string, float f, float f2) {
        if (f != f2) {
            this.addAttribute(string, f);
        }
    }

    public void addAttribute(String string, int n, int n2) {
        if (n != n2) {
            this.addAttribute(string, n);
        }
    }

    public void addAttribute(String string, double d, double d2) {
        if (d != d2) {
            this.addAttribute(string, d);
        }
    }

    public void addAttribute(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.addAttribute(string, bl);
        }
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.equals(string3)) {
            this.addAttribute(string, string2);
        }
    }

    public Object getPrototype() {
        if (this.prototypes == null) {
            this.prototypes = new HashMap();
        }
        if (!this.prototypes.containsKey(this.current.getName())) {
            this.prototypes.put(this.current.getName(), this.factory.create(this.current.getName()));
        }
        return this.prototypes.get(this.current.getName());
    }

    public void setDoctype(String string) {
        this.doctype = string;
    }
}

