/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.container.filter;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    @Context
    private HttpContext hc;
    private long id = 0L;
    private final PrintStream loggingStream;

    public LoggingFilter() {
        this(System.out);
    }

    public LoggingFilter(PrintStream loggingStream) {
        this.loggingStream = loggingStream;
    }

    private synchronized void setId() {
        this.hc.getProperties().put("request-id", Long.toString(++this.id));
    }

    private PrintStream prefixId() {
        this.loggingStream.append(this.hc.getProperties().get("request-id").toString()).append(" ");
        return this.loggingStream;
    }

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        this.setId();
        this.printRequestLine(request);
        this.printRequestHeaders(request.getRequestHeaders());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = request.getEntityInputStream();
        try {
            int read;
            byte[] data = new byte[2048];
            while ((read = in.read(data)) != -1) {
                out.write(data, 0, read);
            }
            byte[] requestEntity = out.toByteArray();
            this.printRequestEntity(requestEntity);
            request.setEntityInputStream(new ByteArrayInputStream(requestEntity));
            return request;
        }
        catch (IOException ex) {
            throw new ContainerException((Throwable)ex);
        }
    }

    private void printRequestLine(ContainerRequest request) {
        this.prefixId().append(NOTIFICATION_PREFIX).append("In-bound request received").println();
        this.prefixId().append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getRequestUri().toASCIIString()).println();
    }

    private void printRequestHeaders(MultivaluedMap<String, String> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                this.prefixId().append(REQUEST_PREFIX).append(header).append(": ").append(value).println();
            }
        }
        this.prefixId().println(REQUEST_PREFIX);
    }

    private void printRequestEntity(byte[] requestEntity) throws IOException {
        if (requestEntity.length == 0) {
            return;
        }
        this.loggingStream.write(requestEntity);
        this.loggingStream.println();
    }

    @Override
    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        response.setContainerResponseWriter(new Adapter(response.getContainerResponseWriter()));
        return response;
    }

    private void printResponseLine(ContainerResponse response) {
        this.prefixId().append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).println();
    }

    private void printResponseHeaders(MultivaluedMap<String, Object> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (Object value : (List)e.getValue()) {
                this.prefixId().append(RESPONSE_PREFIX).append(header).append(": ").append(ContainerResponse.getHeaderValue(value)).println();
            }
        }
        this.prefixId().println(RESPONSE_PREFIX);
    }

    private final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;
        private LoggingOutputStream out;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            LoggingFilter.this.printResponseLine(response);
            LoggingFilter.this.printResponseHeaders((MultivaluedMap<String, Object>)response.getHttpHeaders());
            this.out = new LoggingOutputStream(this.crw.writeStatusAndHeaders(-1L, response));
            return this.out;
        }

        public void finish() throws IOException {
            this.out.finish();
        }
    }

    private final class LoggingOutputStream
    extends OutputStream {
        private boolean init = false;
        private OutputStream out;

        LoggingOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(byte[] b) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b);
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b, off, len);
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b);
            this.out.write(b);
        }

        public void close() throws IOException {
            this.finish();
            this.out.close();
        }

        private final void init() {
            if (!this.init) {
                this.init = true;
            }
        }

        private final void finish() {
            if (this.init) {
                LoggingFilter.this.loggingStream.println();
                LoggingFilter.this.prefixId().append(LoggingFilter.NOTIFICATION_PREFIX).append("Out-bound response sent").println();
                this.init = false;
            }
        }
    }
}

