/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.service;

import com.sun.jersey.impl.SpiMessages;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.service.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceFinder<T>
implements Iterable<T> {
    private static final Logger LOGGER = Logger.getLogger(ServiceFinder.class.getName());
    private static final String PREFIX = "META-INF/services/";
    private static final ComponentProvider DEFAULT_COMPONENT_PROVIDER = new ComponentProvider(){

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            return c.newInstance();
        }

        @Override
        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            throw new UnsupportedOperationException("");
        }

        @Override
        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            return this.getInstance(scope, c);
        }

        @Override
        public <T> T getInjectableInstance(T instance) {
            return instance;
        }

        @Override
        public void inject(Object instance) {
            throw new UnsupportedOperationException("");
        }
    };
    private final Class<T> serviceClass;
    private final ClassLoader classLoader;
    private final boolean ignoreOnClassNotFound;
    private final ComponentProvider componentProvider;

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader) throws ServiceConfigurationError {
        return ServiceFinder.find(service, loader, false, DEFAULT_COMPONENT_PROVIDER);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) throws ServiceConfigurationError {
        return new ServiceFinder<T>(service, loader, ignoreOnClassNotFound, componentProvider);
    }

    public static <T> ServiceFinder<T> find(Class<T> service) throws ServiceConfigurationError {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader(), false, DEFAULT_COMPONENT_PROVIDER);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, boolean ignoreOnClassNotFound) throws ServiceConfigurationError {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader(), ignoreOnClassNotFound, DEFAULT_COMPONENT_PROVIDER);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) throws ServiceConfigurationError {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader(), ignoreOnClassNotFound, componentProvider);
    }

    private ServiceFinder(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) {
        this.serviceClass = service;
        this.classLoader = loader;
        this.ignoreOnClassNotFound = ignoreOnClassNotFound;
        this.componentProvider = componentProvider;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyObjectIterator(this.serviceClass, this.classLoader, this.ignoreOnClassNotFound, this.componentProvider);
    }

    public Iterator<Class<T>> classIterator() {
        return new LazyClassIterator(this.serviceClass, this.classLoader, this.ignoreOnClassNotFound, this.componentProvider);
    }

    public T[] toArray() throws ServiceConfigurationError {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : this) {
            result.add(t);
        }
        return result.toArray((Object[])Array.newInstance(this.serviceClass, result.size()));
    }

    public Class<T>[] toClassArray() throws ServiceConfigurationError {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        Iterator<Class<T>> i = this.classIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.toArray((Class[])Array.newInstance(Class.class, result.size()));
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        ServiceConfigurationError sce = new ServiceConfigurationError(service.getName() + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail(service, u + ":" + line + ": " + msg);
    }

    private static int parseLine(Class service, URL u, BufferedReader r, int lc, List<String> names, Set<String> returned) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceFinder.fail(service, u, lc, SpiMessages.ILLEGAL_CONFIG_SYNTAX());
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceFinder.fail(service, u, lc, SpiMessages.ILLEGAL_PROVIDER_CLASS_NAME(ln));
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceFinder.fail(service, u, lc, SpiMessages.ILLEGAL_PROVIDER_CLASS_NAME(ln));
            }
            if (!returned.contains(ln)) {
                names.add(ln);
                returned.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class service, URL u, Set<String> returned) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            URLConnection uConn = u.openConnection();
            uConn.setUseCaches(false);
            in = uConn.getInputStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = ServiceFinder.parseLine(service, u, r, lc, names, returned)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceFinder.fail(service, ": " + x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceFinder.fail(service, ": " + y);
            }
        }
        return names.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LazyObjectIterator<T>
    extends AbstractLazyIterator<T>
    implements Iterator<T> {
        private T t;

        private LazyObjectIterator(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) {
            super(service, loader, ignoreOnClassNotFound, componentProvider);
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            this.setConfigs();
            while (this.nextName == null) {
                while (this.pending == null || !this.pending.hasNext()) {
                    if (!this.configs.hasMoreElements()) {
                        return false;
                    }
                    this.pending = ServiceFinder.parse(this.service, (URL)this.configs.nextElement(), this.returned);
                }
                this.nextName = (String)this.pending.next();
                try {
                    this.t = this.service.cast(this.componentProvider.getInstance(null, Class.forName(this.nextName, true, this.loader)));
                }
                catch (ClassNotFoundException ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, SpiMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.service, SpiMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                }
                catch (NoClassDefFoundError ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.log(Level.CONFIG, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.service, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service), ex);
                }
                catch (ClassFormatError ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.log(Level.CONFIG, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.service, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service), ex);
                }
                catch (Exception ex) {
                    ServiceFinder.fail(this.service, SpiMessages.PROVIDER_COULD_NOT_BE_CREATED(this.nextName, this.service, ex.getLocalizedMessage()), ex);
                }
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            return this.t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LazyClassIterator<T>
    extends AbstractLazyIterator<T>
    implements Iterator<Class<T>> {
        private LazyClassIterator(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) {
            super(service, loader, ignoreOnClassNotFound, componentProvider);
        }

        @Override
        public Class<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                return Class.forName(cn, true, this.loader);
            }
            catch (ClassNotFoundException ex) {
                ServiceFinder.fail(this.service, SpiMessages.PROVIDER_NOT_FOUND(cn, this.service));
            }
            catch (NoClassDefFoundError ex) {
                ServiceFinder.fail(this.service, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), cn, this.service));
            }
            catch (ClassFormatError ex) {
                ServiceFinder.fail(this.service, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), cn, this.service));
            }
            catch (Exception x) {
                ServiceFinder.fail(this.service, SpiMessages.PROVIDER_CLASS_COULD_NOT_BE_LOADED(cn, this.service, x.getLocalizedMessage()), x);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractLazyIterator<T> {
        final Class<T> service;
        final ClassLoader loader;
        final boolean ignoreOnClassNotFound;
        final ComponentProvider componentProvider;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;

        private AbstractLazyIterator(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound, ComponentProvider componentProvider) {
            this.service = service;
            this.loader = loader;
            this.ignoreOnClassNotFound = ignoreOnClassNotFound;
            this.componentProvider = componentProvider;
        }

        protected final void setConfigs() {
            if (this.configs == null) {
                try {
                    String fullName = ServiceFinder.PREFIX + this.service.getName();
                    if (this.loader == null) {
                        this.setDefaultConfigs(fullName);
                    } else {
                        this.configs = this.loader.getResources(fullName);
                        if (!this.configs.hasMoreElements()) {
                            this.setDefaultConfigs(fullName);
                        }
                    }
                }
                catch (IOException x) {
                    ServiceFinder.fail(this.service, ": " + x);
                }
            }
        }

        private final void setDefaultConfigs(String fullName) throws IOException {
            this.configs = ServiceFinder.class.getClassLoader() != null ? ServiceFinder.class.getClassLoader().getResources(fullName) : ClassLoader.getSystemResources(fullName);
        }

        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            this.setConfigs();
            while (this.nextName == null) {
                while (this.pending == null || !this.pending.hasNext()) {
                    if (!this.configs.hasMoreElements()) {
                        return false;
                    }
                    this.pending = ServiceFinder.parse(this.service, this.configs.nextElement(), this.returned);
                }
                this.nextName = this.pending.next();
                if (!this.ignoreOnClassNotFound) continue;
                try {
                    Class.forName(this.nextName, true, this.loader);
                }
                catch (ClassNotFoundException ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, SpiMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                    }
                    this.nextName = null;
                }
                catch (NoClassDefFoundError ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service));
                    }
                    this.nextName = null;
                }
                catch (ClassFormatError ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, SpiMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service));
                    }
                    this.nextName = null;
                }
            }
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

