/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.io.Files;
import org.zkoss.zats.ZatsException;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.ZatsEnvironment;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EmulatorClient;
import org.zkoss.zats.mimic.impl.emulator.Emulator;
import org.zkoss.zats.mimic.impl.emulator.EmulatorBuilder;

public class DefaultZatsEnvironment
implements ZatsEnvironment {
    private List<Client> clients = new LinkedList<Client>();
    private Emulator emulator;
    private String webInfPathOrUrl;
    private File tmpWebInfFolder;
    private String contextPath;

    public DefaultZatsEnvironment() {
        this(null, null);
    }

    public DefaultZatsEnvironment(String webInfPathOrUrl) {
        this.webInfPathOrUrl = webInfPathOrUrl;
    }

    public DefaultZatsEnvironment(String webInfPathOrUrl, String contextPath) {
        this.webInfPathOrUrl = webInfPathOrUrl;
        this.contextPath = contextPath;
    }

    public void init(String resourceRoot) {
        if (this.emulator != null) {
            throw new ZatsException("already started up");
        }
        if (this.webInfPathOrUrl == null) {
            URL weburl = EmulatorClient.class.getResource("WEB-INF/web.xml");
            if (weburl == null) {
                throw new IllegalStateException("built-in web.xml not found");
            }
            this.webInfPathOrUrl = weburl.toExternalForm();
            this.webInfPathOrUrl = this.webInfPathOrUrl.substring(0, this.webInfPathOrUrl.lastIndexOf(47) + 1);
        }
        this.makeTmpWebInf();
        EmulatorBuilder builder = new EmulatorBuilder();
        builder.setWebInf(this.webInfPathOrUrl);
        builder.setContextPath(this.contextPath == null ? "/" : this.contextPath);
        builder.addContentRoot(resourceRoot);
        this.emulator = builder.create();
    }

    private void makeTmpWebInf() {
        PrintWriter writer = null;
        try {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                this.webInfPathOrUrl = os.indexOf("win") >= 0 ? this.webInfPathOrUrl.replace("file:/", "") : this.webInfPathOrUrl.replace("file:", "");
                File srcFolder = new File(this.webInfPathOrUrl);
                this.tmpWebInfFolder = new File(System.getProperty("java.io.tmpdir"), "ZATS-TMP-WEB-INF");
                String tmpWebInfPathOrUrl = this.tmpWebInfFolder.getAbsolutePath();
                if (this.tmpWebInfFolder.exists()) {
                    Files.deleteAll((File)this.tmpWebInfFolder);
                }
                Files.copy((File)this.tmpWebInfFolder, (File)srcFolder, (int)Files.CP_OVERWRITE);
                Document zkxml = new SAXBuilder(true, false, true).build(new File(this.webInfPathOrUrl, "zk.xml"));
                Element el = zkxml.getRootElement();
                Element listener = new Element("listener");
                Element listenerclass = new Element("listener-class");
                listenerclass.setContent((Object)"org.zkoss.zats.mimic.exception.ZKExecutionCleanup");
                listener.appendChild((Node)listenerclass);
                el.appendChild((Node)listener);
                File originZKXml = new File(this.tmpWebInfFolder, "zk.xml");
                if (!originZKXml.delete()) {
                    throw new ZatsException("Can't remove zk.xml under " + tmpWebInfPathOrUrl);
                }
                DOMSource domSource = new DOMSource((Node)zkxml);
                writer = new PrintWriter(originZKXml);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                writer.println();
                this.webInfPathOrUrl = tmpWebInfPathOrUrl;
            }
            catch (Exception e) {
                throw new ZatsException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void deleteTmpWebInf() {
        this.webInfPathOrUrl = null;
        if (this.tmpWebInfFolder != null && this.tmpWebInfFolder.exists()) {
            Files.deleteAll((File)this.tmpWebInfFolder);
        }
    }

    public void destroy() {
        this.cleanup();
        if (this.emulator != null) {
            this.emulator.close();
            this.emulator = null;
        }
        this.deleteTmpWebInf();
    }

    public Client newClient() {
        if (this.emulator == null) {
            throw new ZatsException("not initialize yet, please call init first");
        }
        EmulatorClient client = new EmulatorClient(this.emulator);
        ((ClientCtrl)client).setDestroyListener(new ClientCtrl.DestroyListener(){

            public void willDestroy(Client conv) {
                DefaultZatsEnvironment.this.clients.remove(conv);
            }
        });
        this.clients.add(client);
        return client;
    }

    public void cleanup() {
        Client[] clientArray = this.clients.toArray(new Client[this.clients.size()]);
        int n = clientArray.length;
        int n2 = 0;
        while (n2 < n) {
            Client c = clientArray[n2];
            c.destroy();
            ++n2;
        }
    }
}

