/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.PageAgent;
import org.zkoss.zats.mimic.impl.Searcher;
import org.zkoss.zats.mimic.impl.ValueResolverManager;
import org.zkoss.zats.mimic.operation.CheckAgent;
import org.zkoss.zats.mimic.operation.ClickAgent;
import org.zkoss.zats.mimic.operation.FocusAgent;
import org.zkoss.zats.mimic.operation.InputAgent;
import org.zkoss.zats.mimic.operation.KeyStrokeAgent;
import org.zkoss.zats.mimic.operation.SelectAgent;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentAgent
implements ComponentAgent {
    private PageAgent pageAgent;
    private Component comp;

    public DefaultComponentAgent(PageAgent pageAgent, Component component) {
        this.pageAgent = pageAgent;
        this.comp = component;
    }

    @Override
    public String getId() {
        return this.comp.getId();
    }

    public String getType() {
        return this.comp.getDefinition().getName();
    }

    @Override
    public Object getAttribute(String name) {
        return this.comp.getAttribute(name);
    }

    @Override
    public String getUuid() {
        return this.comp.getUuid();
    }

    @Override
    public List<ComponentAgent> getChildren() {
        List children = this.comp.getChildren();
        ArrayList<ComponentAgent> agents = new ArrayList<ComponentAgent>(children.size());
        for (Component child : children) {
            agents.add(new DefaultComponentAgent(this.pageAgent, child));
        }
        return agents;
    }

    @Override
    public ComponentAgent getFirstChild() {
        return this.asAgent(this.comp.getFirstChild());
    }

    @Override
    public ComponentAgent getLastChild() {
        return this.asAgent(this.comp.getLastChild());
    }

    private ComponentAgent asAgent(Component child) {
        return child != null ? new DefaultComponentAgent(this.pageAgent, child) : null;
    }

    @Override
    public ComponentAgent getNextSibling() {
        return this.asAgent(this.comp.getNextSibling());
    }

    @Override
    public ComponentAgent getPreviousSibling() {
        return this.asAgent(this.comp.getPreviousSibling());
    }

    @Override
    public ComponentAgent getChild(int index) {
        List children = this.comp.getChildren();
        if (index < 0 || children.size() <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + children.size());
        }
        return this.asAgent((Component)children.get(index));
    }

    @Override
    public ComponentAgent getParent() {
        return this.asAgent(this.comp.getParent());
    }

    @Override
    public Client getClient() {
        return this.getDesktop().getClient();
    }

    @Override
    public DesktopAgent getDesktop() {
        return this.pageAgent.getDesktop();
    }

    @Override
    public PageAgent getPage() {
        return this.pageAgent;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        if (obj != null) {
            return obj;
        }
        throw new AgentException("cannot resolve " + clazz.getName() + " for " + this.getType());
    }

    @Override
    public <T> boolean is(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        return obj != null;
    }

    public int hashCode() {
        return this.comp.hashCode();
    }

    public boolean equals(Object obj) {
        return this.comp.equals(obj);
    }

    @Override
    public ComponentAgent query(String selector) {
        return Searcher.find(this, selector);
    }

    @Override
    public List<ComponentAgent> queryAll(String selector) {
        return Searcher.findAll(this, selector);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.comp.toString() + "]";
    }

    public void dump() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb, this, 0);
        System.out.println(sb.toString());
    }

    private void dump(StringBuilder sb, ComponentAgent agent, int indent) {
        List<ComponentAgent> children = agent.getChildren();
        StringBuffer idt = new StringBuffer();
        int i = 0;
        while (i < indent) {
            idt.append("  ");
            ++i;
        }
        sb.append(idt);
        Component zkc = agent.as(Component.class);
        String nm = zkc.getClass().getSimpleName();
        sb.append("<");
        sb.append(nm);
        sb.append(" uuid=\"").append(zkc.getUuid()).append("\"");
        String id = zkc.getId();
        if (id != null) {
            sb.append(" id=\"").append(id).append("\"");
        }
        if (children.size() > 0) {
            sb.append(">\n");
        } else {
            sb.append(" />\n");
        }
        for (ComponentAgent w : children) {
            this.dump(sb, w, indent + 1);
        }
        if (children.size() > 0) {
            sb.append(idt);
            sb.append("</").append(nm).append(">\n");
        }
    }

    @Override
    public Object getDelegatee() {
        return this.getOwner();
    }

    @Override
    public <T extends Component> T getOwner() {
        return (T)this.comp;
    }

    @Override
    public void click() {
        this.as(ClickAgent.class).click();
    }

    @Override
    public void type(String value) {
        this.as(InputAgent.class).type(value);
    }

    @Override
    public void input(Object value) {
        this.as(InputAgent.class).input(value);
    }

    @Override
    public void focus() {
        this.as(FocusAgent.class).focus();
    }

    @Override
    public void blur() {
        this.as(FocusAgent.class).blur();
    }

    @Override
    public void check(boolean checked) {
        this.as(CheckAgent.class).check(checked);
    }

    @Override
    public void stroke(String key) {
        this.as(KeyStrokeAgent.class).stroke(key);
    }

    @Override
    public void select() {
        this.as(SelectAgent.class).select();
    }
}

