/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.PageAgent;
import org.zkoss.zats.mimic.Resource;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.DefaultPageAgent;
import org.zkoss.zats.mimic.impl.DesktopCtrl;
import org.zkoss.zats.mimic.impl.Searcher;
import org.zkoss.zats.mimic.impl.ValueResolverManager;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDesktopAgent
implements DesktopAgent,
DesktopCtrl {
    private Client client;
    private Desktop desktop;
    private Resource downloadable;

    public DefaultDesktopAgent(Client client, Desktop desktop) {
        this.client = client;
        this.desktop = desktop;
    }

    @Override
    public String getId() {
        return this.desktop.getId();
    }

    public String getType() {
        return "desktop";
    }

    @Override
    public Object getAttribute(String name) {
        return this.desktop.getAttribute(name);
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public List<PageAgent> getPages() {
        ArrayList<PageAgent> agents = new ArrayList<PageAgent>();
        Iterator iter = this.desktop.getPages().iterator();
        while (iter.hasNext()) {
            agents.add(new DefaultPageAgent(this, (Page)iter.next()));
        }
        return agents;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public int hashCode() {
        return this.desktop.hashCode();
    }

    public boolean equals(Object obj) {
        return this.desktop.equals(obj);
    }

    @Override
    public Object getDelegatee() {
        return this.desktop;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.desktop.toString() + "]";
    }

    @Override
    public ComponentAgent query(String selector) {
        return Searcher.find(this, selector);
    }

    @Override
    public List<ComponentAgent> queryAll(String selector) {
        return Searcher.findAll(this, selector);
    }

    @Override
    public void destroy() {
        ((ClientCtrl)((Object)this.getClient())).destroy(this);
    }

    @Override
    public <T> T as(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        if (obj != null) {
            return obj;
        }
        throw new AgentException("cannot resolve " + clazz.getName() + " for " + this.getType());
    }

    @Override
    public <T> boolean is(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        return obj != null;
    }

    @Override
    public void setDownloadable(Resource downloadable) {
        this.downloadable = downloadable;
    }

    @Override
    public Resource getDownloadable() {
        return this.downloadable;
    }
}

