/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.PageAgent;
import org.zkoss.zats.mimic.impl.DefaultComponentAgent;
import org.zkoss.zats.mimic.impl.Searcher;
import org.zkoss.zats.mimic.impl.ValueResolverManager;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPageAgent
implements PageAgent {
    private DesktopAgent desktopAgent;
    private Page page;

    public DefaultPageAgent(DesktopAgent desktopAgent, Page page) {
        this.desktopAgent = desktopAgent;
        this.page = page;
    }

    @Override
    public String getId() {
        return this.page.getId();
    }

    public String getType() {
        return "page";
    }

    @Override
    public Object getAttribute(String name) {
        return this.page.getAttribute(name);
    }

    @Override
    public String getUuid() {
        return this.page.getUuid();
    }

    @Override
    public List<ComponentAgent> getRoots() {
        ArrayList<ComponentAgent> agents = new ArrayList<ComponentAgent>();
        Iterator iterator = this.page.getRoots().iterator();
        while (iterator.hasNext()) {
            agents.add(new DefaultComponentAgent(this, (Component)iterator.next()));
        }
        return agents;
    }

    @Override
    public Client getClient() {
        return this.desktopAgent.getClient();
    }

    @Override
    public DesktopAgent getDesktop() {
        return this.desktopAgent;
    }

    public Page getPage() {
        return this.page;
    }

    public int hashCode() {
        return this.page.hashCode();
    }

    public boolean equals(Object obj) {
        return this.page.equals(obj);
    }

    @Override
    public Object getDelegatee() {
        return this.page;
    }

    @Override
    public ComponentAgent query(String selector) {
        return Searcher.find(this, selector);
    }

    @Override
    public List<ComponentAgent> queryAll(String selector) {
        return Searcher.findAll(this, selector);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.page.toString() + "]";
    }

    @Override
    public <T> T as(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        if (obj != null) {
            return obj;
        }
        throw new AgentException("cannot resolve " + clazz.getName() + " for " + this.getType());
    }

    @Override
    public <T> boolean is(Class<T> clazz) {
        T obj = ValueResolverManager.getInstance().resolve(this, clazz);
        return obj != null;
    }
}

