/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.UrlEncoded;
import org.zkoss.zats.ZatsException;
import org.zkoss.zats.common.json.JSONValue;
import org.zkoss.zats.common.json.parser.ParseException;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.EchoEventMode;
import org.zkoss.zats.mimic.exception.ZKExceptionHandler;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.DefaultDesktopAgent;
import org.zkoss.zats.mimic.impl.LayoutResponseHandler;
import org.zkoss.zats.mimic.impl.ResponseHandlerManager;
import org.zkoss.zats.mimic.impl.UpdateResponseHandler;
import org.zkoss.zats.mimic.impl.au.AuUtility;
import org.zkoss.zats.mimic.impl.emulator.Emulator;
import org.zkoss.zk.ui.Desktop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmulatorClient
implements Client,
ClientCtrl {
    private static Logger logger = Logger.getLogger(EmulatorClient.class.getName());
    private Emulator emulator;
    private Map<String, DesktopAgent> desktopAgents = new HashMap<String, DesktopAgent>();
    private Map<String, String> cookies = new HashMap<String, String>();
    private ClientCtrl.DestroyListener destroyListener;
    private Map<String, List<UpdateEvent>> auQueues;
    private Map<String, List<UpdateEvent>> auQueues4piggyback;
    private EchoEventMode echoEventMode = EchoEventMode.IMMEDIATE;

    public EmulatorClient(Emulator emulator) {
        this.emulator = emulator;
        this.auQueues = new ConcurrentHashMap<String, List<UpdateEvent>>();
        this.auQueues4piggyback = new ConcurrentHashMap<String, List<UpdateEvent>>();
    }

    @Override
    public DesktopAgent connectAsIncluded(String zulPath, Map<String, Object> args) {
        if (zulPath == null) {
            throw new IllegalArgumentException("the path of ZUL can't be null");
        }
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        String key = "zats_" + Long.toString(Thread.currentThread().getId(), 36);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("url", zulPath);
        data.put("args", args);
        this.emulator.getServletContext().setAttribute(key, data);
        String adapter = "/~./zats/includingAdapter.zul?id=" + key;
        DesktopAgent desktop = this.connect(adapter);
        this.emulator.getServletContext().removeAttribute(key);
        data.clear();
        return desktop;
    }

    @Override
    public DesktopAgent connectWithContent(String content, String ext, ComponentAgent parent, Map<String, Object> args) {
        if (content == null) {
            throw new IllegalArgumentException("the content of ZUL can't be null");
        }
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        String key = "zats_" + Long.toString(Thread.currentThread().getId(), 36);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", content);
        data.put("ext", ext);
        data.put("args", args);
        if (parent != null) {
            data.put("parent", parent.getOwner());
        }
        this.emulator.getServletContext().setAttribute(key, data);
        String adapter = "/~./zats/createComponentsDirectlyAdapter.zul?id=" + key;
        DesktopAgent desktop = this.connect(adapter);
        this.emulator.getServletContext().removeAttribute(key);
        data.clear();
        return desktop;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DesktopAgent connect(String zulPath) {
        if (zulPath == null) {
            throw new IllegalArgumentException("the path of ZUL can't be null");
        }
        InputStream is = null;
        try {
            HttpURLConnection huc = this.getConnection(zulPath, "GET");
            huc.connect();
            this.fetchCookies(huc);
            List l = ZKExceptionHandler.getInstance().getExceptions();
            if (l.size() > 0) {
                throw (Throwable)l.get(0);
            }
            is = huc.getInputStream();
            String raw = this.getReplyString(is, huc.getContentEncoding());
            Desktop desktop = (Desktop)this.emulator.getRequestAttributes().get("javax.zkoss.zk.ui.desktop");
            DefaultDesktopAgent desktopAgent = new DefaultDesktopAgent(this, desktop);
            this.desktopAgents.put(desktopAgent.getId(), desktopAgent);
            List<LayoutResponseHandler> handlers = ResponseHandlerManager.getInstance().getLayoutResponseHandlers();
            Iterator<LayoutResponseHandler> iterator = handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("HTTP response header: " + huc.getHeaderFields());
                        logger.finest("HTTP response content: " + raw);
                    }
                    this.flush(desktopAgent.getId());
                    DefaultDesktopAgent defaultDesktopAgent = desktopAgent;
                    this.close(is);
                    ZKExceptionHandler.getInstance().destroy();
                    return defaultDesktopAgent;
                }
                LayoutResponseHandler h = iterator.next();
                try {
                    h.process(desktopAgent, raw);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new ZatsException(e.getMessage(), (Throwable)e);
                catch (Throwable t) {
                    throw new ZatsException(t.getMessage(), t);
                }
            }
            catch (Throwable throwable) {
                this.close(is);
                ZKExceptionHandler.getInstance().destroy();
                throw throwable;
            }
        }
    }

    @Override
    public void destroy() {
        if (this.destroyListener != null) {
            this.destroyListener.willDestroy(this);
        }
        for (DesktopAgent d : this.desktopAgents.values()) {
            this.destroy(d);
        }
        this.desktopAgents.clear();
        this.cookies.clear();
        this.auQueues.clear();
        this.auQueues4piggyback.clear();
    }

    @Override
    public void destroy(DesktopAgent desktopAgent) {
        this.postUpdate(desktopAgent.getId(), null, "rmDesktop", null, true);
        this.flush(desktopAgent.getId());
    }

    @Override
    public void postUpdate(String desktopId, String targetUUID, String command, Map<String, Object> data, boolean ignorable) {
        this.postUpdate(desktopId, targetUUID, command, data, ignorable, false);
    }

    @Override
    public void postPiggyback(String desktopId, String targetUUID, String command, Map<String, Object> data, boolean ignorable) {
        this.postUpdate(desktopId, targetUUID, command, data, ignorable, true);
    }

    private void postUpdate(String desktopId, String targetUUID, String command, Map<String, Object> data, boolean ignorable, boolean piggyback) {
        if (desktopId == null) {
            throw new IllegalArgumentException("desktop id is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        Map<String, List<UpdateEvent>> queues = piggyback ? this.auQueues4piggyback : this.auQueues;
        List<UpdateEvent> queue = queues.get(desktopId);
        if (queue == null) {
            queue = new LinkedList<UpdateEvent>();
            queues.put(desktopId, queue);
        }
        queue.add(new UpdateEvent(targetUUID, command, data, ignorable));
    }

    private String getCombinedEventString(String desktopId) {
        LinkedList queue = new LinkedList();
        if (this.auQueues4piggyback.containsKey(desktopId)) {
            queue.addAll(this.auQueues4piggyback.remove(desktopId));
        }
        if (this.auQueues.containsKey(desktopId)) {
            queue.addAll(this.auQueues.remove(desktopId));
        }
        if (queue.size() <= 0) {
            return null;
        }
        int index = 0;
        StringBuilder sb = new StringBuilder();
        while (!queue.isEmpty()) {
            UpdateEvent event = (UpdateEvent)queue.remove(0);
            sb.append("&cmd_").append(index).append("=").append(event.cmd);
            if (event.uuid != null) {
                String uuid = UrlEncoded.encodeString((String)event.uuid);
                sb.append("&uuid_").append(index).append("=").append(uuid);
            }
            if (event.data != null && event.data.size() > 0) {
                String jsonData = UrlEncoded.encodeString((String)JSONValue.toJSONString(event.data));
                sb.append("&data_").append(index).append("=").append(jsonData);
            }
            if (event.ignorable) {
                sb.append("&opt_").append(index).append("=").append("i");
            }
            ++index;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Desktop " + desktopId + " perform AU: " + UrlEncoded.decodeString((String)sb.toString(), (int)0, (int)sb.length(), (String)"utf-8"));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush(String desktopId) {
        OutputStream os = null;
        InputStream is = null;
        while (true) {
            block16: {
                String combinedEvents;
                StringBuilder sb;
                if (!this.auQueues.containsKey(desktopId) || this.auQueues.get(desktopId).size() <= 0) {
                    return;
                }
                try {
                    sb = new StringBuilder();
                    sb.append("dtid=").append(UrlEncoded.encodeString((String)desktopId));
                    combinedEvents = this.getCombinedEventString(desktopId);
                    if (combinedEvents == null) {
                        this.close(os);
                        this.close(is);
                        ZKExceptionHandler.getInstance().destroy();
                        return;
                    }
                }
                catch (ParseException e) {
                    logger.log(Level.SEVERE, "unexpect exception when parsing JSON", e);
                    this.close(os);
                    this.close(is);
                    ZKExceptionHandler.getInstance().destroy();
                    continue;
                }
                catch (Exception e) {
                    try {
                        throw new ZatsException(e.getMessage(), (Throwable)e);
                        catch (Throwable t) {
                            throw new ZatsException(t.getMessage(), t);
                        }
                    }
                    catch (Throwable throwable) {
                        this.close(os);
                        this.close(is);
                        ZKExceptionHandler.getInstance().destroy();
                        throw throwable;
                    }
                }
                {
                    String content = sb.append(combinedEvents).toString();
                    HttpURLConnection c = this.getConnection("/zkau", "POST");
                    c.setDoOutput(true);
                    c.setDoInput(true);
                    c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("HTTP request header: " + c.getRequestProperties());
                        logger.finest("HTTP request content: " + content);
                    }
                    c.connect();
                    os = c.getOutputStream();
                    os.write(content.getBytes("utf-8"));
                    this.close(os);
                    this.fetchCookies(c);
                    List l = ZKExceptionHandler.getInstance().getExceptions();
                    if (l.size() > 0) {
                        throw (Throwable)l.get(0);
                    }
                    is = c.getInputStream();
                    String raw = this.getReplyString(is, c.getContentEncoding());
                    raw = AuUtility.filterNonJSON(raw);
                    Map json = (Map)JSONValue.parseWithException((String)raw);
                    List<UpdateResponseHandler> handlers = ResponseHandlerManager.getInstance().getUpdateResponseHandlers();
                    for (UpdateResponseHandler h : handlers) {
                        try {
                            h.process(this.desktopAgents.get(desktopId), json);
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    if (!logger.isLoggable(Level.FINEST)) break block16;
                    logger.finest("HTTP response header: " + c.getHeaderFields());
                    logger.finest("HTTP response content: " + raw);
                }
            }
            this.close(os);
            this.close(is);
            ZKExceptionHandler.getInstance().destroy();
        }
    }

    @Override
    public HttpURLConnection getConnection(String path, String method) {
        try {
            URL url = new URL(String.valueOf(this.emulator.getAddress()) + path);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod(method);
            huc.setUseCaches(false);
            huc.addRequestProperty("Host", String.valueOf(this.emulator.getHost()) + ":" + this.emulator.getPort());
            huc.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0)");
            huc.addRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            huc.addRequestProperty("Accept-Language", "zh-tw,en-us;q=0.7,en;q=0.3");
            for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
                String value = cookie.getValue() != null ? cookie.getValue() : "";
                huc.addRequestProperty("Cookie", String.valueOf(cookie.getKey()) + "=" + value);
            }
            return huc;
        }
        catch (Exception e) {
            throw new ZatsException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public InputStream openConnection(String path) throws IOException {
        HttpURLConnection c = this.getConnection(path, "GET");
        c.setDoOutput(false);
        c.setDoInput(true);
        return c.getInputStream();
    }

    private void close(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getReplyString(InputStream is, String encoding) {
        String reply;
        block6: {
            reply = null;
            BufferedReader r = null;
            try {
                try {
                    int c;
                    StringBuilder sb = new StringBuilder();
                    r = new BufferedReader(new InputStreamReader(is, encoding != null ? encoding : "ISO-8859-1"));
                    while ((c = ((Reader)r).read()) >= 0) {
                        sb.append((char)c);
                    }
                    reply = sb.toString();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "", e);
                    this.close(r);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(r);
                throw throwable;
            }
            this.close(r);
        }
        return reply;
    }

    @Override
    public void setDestroyListener(ClientCtrl.DestroyListener l) {
        this.destroyListener = l;
    }

    private void fetchCookies(HttpURLConnection connection) {
        List<String> list = connection.getHeaderFields().get("Set-Cookie");
        if (list == null) {
            return;
        }
        for (String raw : list) {
            try {
                String[] tokens = raw.trim().split(";");
                tokens = tokens[0].split("=");
                this.cookies.put(tokens[0], tokens.length < 2 ? "" : tokens[1]);
                byte[] data = raw.replaceAll(";", "\n").getBytes("ASCII");
                Properties attr = new Properties();
                attr.load(new ByteArrayInputStream(data));
                String expired = attr.getProperty("Expires");
                if (expired == null || expired.length() <= 0) continue;
                try {
                    long time = Date.parse(expired);
                    if (time >= System.currentTimeMillis()) continue;
                    this.cookies.remove(tokens[0]);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "unexpect exception when parsing HTTP Datetime string", e);
                }
            }
            catch (Exception e) {
                new ZatsException("unexpected exception", (Throwable)e);
            }
        }
    }

    @Override
    public void setCookie(String key, String value) {
        if (key == null || key.startsWith("$")) {
            throw new IllegalArgumentException(key == null ? "cookie key name can't be null" : "cookie key name can't be start with '$'");
        }
        if (value != null) {
            this.cookies.put(key, value);
        } else {
            this.cookies.remove(key);
        }
    }

    @Override
    public String getCookie(String key) {
        if (key == null) {
            throw new IllegalArgumentException("cookie key name can't be null");
        }
        return this.cookies.get(key);
    }

    @Override
    public Map<String, String> getCookies() {
        return new HashMap<String, String>(this.cookies);
    }

    @Override
    public void setEchoEventMode(EchoEventMode mode) {
        if (mode != null) {
            this.echoEventMode = mode;
        }
    }

    @Override
    public EchoEventMode getEchoEventMode() {
        return this.echoEventMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateEvent {
        String uuid;
        String cmd;
        Map<String, Object> data;
        boolean ignorable = false;

        UpdateEvent(String uuid, String cmd, Map<String, Object> data, boolean ignorable) {
            this.uuid = uuid;
            this.cmd = cmd;
            this.data = data;
            this.ignorable = ignorable;
        }
    }
}

