/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.impl.EventDataBuilder;
import org.zkoss.zats.mimic.impl.Util;
import org.zkoss.zats.mimic.impl.au.BookmarkEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.CheckEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.ColSizeEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.DefaultEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.DropEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.InputEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.KeyEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.MaximizeEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.MinimizeEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.MouseEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.MoveEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.OpenEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.PagingEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.RenderEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.ScrollEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.SelectEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.SelectionEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.SizeEventDataBuilder;
import org.zkoss.zats.mimic.impl.au.SortEventDataBuilder;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDataManager {
    private static EventDataManager instance;
    private Map<Class<? extends Event>, EventDataBuilder<? extends Event>> builders = new HashMap<Class<? extends Event>, EventDataBuilder<? extends Event>>();

    public static synchronized EventDataManager getInstance() {
        if (instance == null) {
            instance = new EventDataManager();
        }
        return instance;
    }

    public EventDataManager() {
        this.registerBuilder("5.0.0", "*", new MouseEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new InputEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new CheckEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new DefaultEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new OpenEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new SelectEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new KeyEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new RenderEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new MaximizeEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new MinimizeEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new DropEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new SelectionEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new SizeEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new PagingEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new BookmarkEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new ColSizeEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new SortEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new ScrollEventDataBuilder());
        this.registerBuilder("5.0.0", "*", new MoveEventDataBuilder());
    }

    public void registerBuilder(String startVersion, String endVersion, String builderClazz) {
        if (startVersion == null || endVersion == null || builderClazz == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        EventDataBuilder builder = null;
        try {
            Class<?> buildClz = Class.forName(builderClazz);
            builder = (EventDataBuilder)buildClz.newInstance();
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
        this.registerBuilder(startVersion, endVersion, builder);
    }

    public <T extends Event> void registerBuilder(String startVersion, String endVersion, EventDataBuilder<? extends Event> builder) {
        if (startVersion == null || endVersion == null || builder == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        this.builders.put(builder.getEventClass(), builder);
    }

    public Map<String, Object> build(Event evt) {
        Class<?> clz = evt.getClass();
        EventDataBuilder<? extends Event> builder = null;
        while (clz != null) {
            builder = this.builders.get(clz);
            if (builder != null || !Event.class.isAssignableFrom(clz = clz.getSuperclass())) break;
        }
        if (builder == null) {
            throw new AgentException("build for event not found : " + evt);
        }
        return builder.build((Event)evt, new HashMap<String, Object>());
    }
}

