/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zats.mimic.impl.LayoutResponseHandler;
import org.zkoss.zats.mimic.impl.UpdateResponseHandler;
import org.zkoss.zats.mimic.impl.Util;
import org.zkoss.zats.mimic.impl.response.DownloadHandler;
import org.zkoss.zats.mimic.impl.response.EchoEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseHandlerManager {
    private static ResponseHandlerManager instance;
    private Map<String, LayoutResponseHandler> layoutHandlers = new HashMap<String, LayoutResponseHandler>();
    private Map<String, UpdateResponseHandler> updateHandlers = new HashMap<String, UpdateResponseHandler>();

    public static synchronized ResponseHandlerManager getInstance() {
        if (instance == null) {
            instance = new ResponseHandlerManager();
        }
        return instance;
    }

    public ResponseHandlerManager() {
        this.registerHandler("5.0.0", "*", "download", new DownloadHandler());
        this.registerHandler("5.0.0", "5.*.*", "echo", new EchoEventHandler());
        this.registerHandler("5.0.0", "*", "download", new DownloadHandler());
        this.registerHandler("5.0.0", "5.*.*", "echo", new EchoEventHandler());
    }

    public void registerHandler(String startVersion, String endVersion, String key, String className) {
        block4: {
            try {
                Class<?> clazz = Class.forName(className);
                if (LayoutResponseHandler.class.isAssignableFrom(clazz)) {
                    this.registerHandler(startVersion, endVersion, key, (LayoutResponseHandler)clazz.newInstance());
                    break block4;
                }
                if (UpdateResponseHandler.class.isAssignableFrom(clazz)) {
                    this.registerHandler(startVersion, endVersion, key, (UpdateResponseHandler)clazz.newInstance());
                    break block4;
                }
                throw new ClassCastException(String.valueOf(className) + " neither layout response handler nor update response handler");
            }
            catch (Exception x) {
                throw new IllegalArgumentException(x.getMessage(), x);
            }
        }
    }

    public void registerHandler(String startVersion, String endVersion, String key, LayoutResponseHandler handler) {
        if (startVersion == null || endVersion == null || key == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        this.layoutHandlers.put(key, handler);
    }

    public void registerHandler(String startVersion, String endVersion, String key, UpdateResponseHandler handler) {
        if (startVersion == null || endVersion == null || key == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        this.updateHandlers.put(key, handler);
    }

    public List<LayoutResponseHandler> getLayoutResponseHandlers() {
        return new ArrayList<LayoutResponseHandler>(this.layoutHandlers.values());
    }

    public List<UpdateResponseHandler> getUpdateResponseHandlers() {
        return new ArrayList<UpdateResponseHandler>(this.updateHandlers.values());
    }
}

