/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.zkoss.Version;
import org.zkoss.zats.ZatsException;
import org.zkoss.zats.common.select.Selectors;
import org.zkoss.zats.mimic.Agent;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.PageAgent;
import org.zkoss.zats.mimic.impl.DefaultComponentAgent;
import org.zkoss.zats.mimic.impl.DefaultDesktopAgent;
import org.zkoss.zats.mimic.impl.DefaultPageAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Searcher {
    private static Logger logger = Logger.getLogger(Searcher.class.getName());

    Searcher() {
    }

    public static List<ComponentAgent> findAll(Agent parent, String selector) {
        try {
            List foundComponents;
            Class<Object> selectors;
            try {
                selectors = Class.forName("org.zkoss.zk.ui.select.Selectors");
                logger.finest("using zk6 selectors: " + Version.class.getField("UID").get(null));
            }
            catch (ClassNotFoundException e) {
                selectors = Selectors.class;
                logger.finest("using zats selectors: " + Version.class.getField("UID").get(null));
            }
            Method findByPage = selectors.getMethod("find", Page.class, String.class);
            Object base = parent.getDelegatee();
            if (base instanceof Desktop) {
                Collection pages = ((Desktop)base).getPages();
                foundComponents = new ArrayList();
                for (Page p : pages) {
                    List pl;
                    if (p.getFirstRoot() == null || (pl = (List)findByPage.invoke(null, p, selector)) == null || pl.size() <= 0) continue;
                    foundComponents.addAll(pl);
                }
            } else if (base instanceof Page) {
                Page p = (Page)base;
                foundComponents = p.getFirstRoot() == null ? new LinkedList() : (List)findByPage.invoke(null, p, selector);
            } else if (base instanceof Component) {
                Method findByComp = selectors.getMethod("find", Component.class, String.class);
                foundComponents = (List)findByComp.invoke(null, (Component)base, selector);
            } else {
                throw new ZatsException("unsupported type " + base);
            }
            ArrayList<ComponentAgent> foundAgents = new ArrayList<ComponentAgent>(foundComponents.size());
            Agent lastPage = null;
            DefaultDesktopAgent desktopAgent = null;
            for (Component comp : foundComponents) {
                Page pg = comp.getPage();
                if (desktopAgent == null) {
                    desktopAgent = new DefaultDesktopAgent(parent.getClient(), pg.getDesktop());
                }
                if (lastPage == null || !lastPage.getDelegatee().equals(pg)) {
                    lastPage = new DefaultPageAgent(desktopAgent, pg);
                }
                foundAgents.add(new DefaultComponentAgent((PageAgent)lastPage, comp));
            }
            return foundAgents;
        }
        catch (Exception e) {
            throw new ZatsException(e.getMessage(), (Throwable)e);
        }
    }

    public static ComponentAgent find(Agent parent, String selector) {
        List<ComponentAgent> agents = Searcher.findAll(parent, selector);
        return agents.size() > 0 ? agents.get(0) : null;
    }
}

