/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.io.Closeable;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Logger;
import org.zkoss.Version;
import org.zkoss.zats.ZatsException;

public class Util {
    private static Logger logger = Logger.getLogger(Util.class.getName());
    private static BigInteger zkVersion;

    static {
        try {
            String version = Version.class.getField("UID").get(null).toString();
            zkVersion = Util.parseVersion(version);
            if (zkVersion == null) {
                throw new Exception("failed to parse ZK version string: " + version);
            }
        }
        catch (Throwable e) {
            throw new ZatsException("cannot load zk", e);
        }
    }

    public static BigInteger getZKVersion() {
        return zkVersion;
    }

    public static boolean isZKVersion(int primaryVer) {
        byte[] ver = zkVersion.toByteArray();
        if (ver != null && ver.length >= 3) {
            return ver[0] == primaryVer;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasClass(String className) {
        try {
            try {
                Util.class.getClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException x) {
                return false;
            }
        }
        catch (Throwable x2) {
            logger.warning(x2.getMessage());
            return false;
        }
    }

    public static boolean checkVersion(String startVersion, String endVersion) {
        BigInteger end;
        BigInteger start = "*".equals(startVersion.trim()) ? BigInteger.ZERO : Util.parseVersion(startVersion.replaceAll("[*]", "0"));
        BigInteger bigInteger = end = "*".equals(endVersion.trim()) ? BigInteger.valueOf(Long.MAX_VALUE) : Util.parseVersion(endVersion.replaceAll("[*]", String.valueOf(127)));
        if (start == null || end == null) {
            throw new IllegalArgumentException("wrong version format");
        }
        return zkVersion.compareTo(start) >= 0 && zkVersion.compareTo(end) <= 0;
    }

    public static void close(Closeable r) {
        try {
            r.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BigInteger parseVersion(final String version) {
        if (version == null || version.length() <= 0) {
            return null;
        }
        if (!version.matches("^\\s*\\d+(?:\\.\\d+)*\\s*$")) {
            logger.warning("not a normal ZK version: <" + version + ">");
        }
        byte[] raw = new byte[4];
        String[] tokens = version.trim().split("[^\\d\\w]+");
        int length = Math.min(raw.length, tokens.length);
        int i = 0;
        while (i < length) {
            try {
                raw[i] = Byte.parseByte(tokens[i]);
            }
            catch (NumberFormatException e) {
                logger.warning("unrecognized part when parsing version: <" + tokens[i] + ">");
            }
            ++i;
        }
        if (raw[0] <= 0) {
            return null;
        }
        return new BigInteger(raw){
            private static final long serialVersionUID = 2712388085709130462L;

            public String toString() {
                return version;
            }
        };
    }

    public static String generateRandomString() {
        return "zats-" + Integer.toHexString(System.identityHashCode(Util.class)) + new BigInteger(64, new Random()).abs().toString(36);
    }
}

