/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zats.mimic.Agent;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.OperationAgentManager;
import org.zkoss.zats.mimic.impl.Util;
import org.zkoss.zats.mimic.impl.ValueResolver;
import org.zkoss.zats.mimic.operation.OperationAgent;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueResolverManager {
    private static ValueResolverManager instance;
    private Map<String, ValueResolver> resolvers = new HashMap<String, ValueResolver>();

    public static synchronized ValueResolverManager getInstance() {
        if (instance == null) {
            instance = new ValueResolverManager();
        }
        return instance;
    }

    public ValueResolverManager() {
        this.registerResolver("5.0.0", "*", "agent", new ValueResolver(){

            @Override
            public <T> T resolve(Agent agent, Class<T> clazz) {
                if (OperationAgent.class.isAssignableFrom(clazz)) {
                    Class<T> opc = clazz;
                    OperationAgentBuilder<Agent, T> builder = OperationAgentManager.getInstance().getBuilder(agent.getDelegatee(), opc);
                    if (builder != null) {
                        return builder.getOperation(agent);
                    }
                }
                return null;
            }
        });
        this.registerResolver("5.0.0", "*", "component", new ValueResolver(){

            @Override
            public <T> T resolve(Agent agent, Class<T> clazz) {
                if (clazz.isInstance(agent.getDelegatee())) {
                    return (T)agent.getDelegatee();
                }
                return null;
            }
        });
    }

    public void registerResolver(String startVersion, String endVersion, String key, String resolverClazz) {
        if (startVersion == null || endVersion == null || resolverClazz == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        ValueResolver resolver = null;
        try {
            Class<?> buildClz = Class.forName(resolverClazz);
            resolver = (ValueResolver)buildClz.newInstance();
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
        this.registerResolver(startVersion, endVersion, key, resolver);
    }

    public <T extends Event> void registerResolver(String startVersion, String endVersion, String key, ValueResolver resolver) {
        if (startVersion == null || endVersion == null || key == null || resolver == null) {
            throw new IllegalArgumentException();
        }
        if (!Util.checkVersion(startVersion, endVersion)) {
            return;
        }
        this.resolvers.put(key, resolver);
    }

    public <T> T resolve(Agent agent, Class<T> clazz) {
        for (ValueResolver r : this.resolvers.values()) {
            T obj = r.resolve(agent, clazz);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }
}

