/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.au;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.zkoss.zats.ZatsException;
import org.zkoss.zats.common.json.JSONArray;
import org.zkoss.zats.common.json.JSONValue;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zsoup.Zsoup;
import org.zkoss.zsoup.nodes.Document;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuUtility {
    public static ComponentAgent lookupEventTarget(ComponentAgent c, String evtname) {
        if (c == null) {
            return null;
        }
        Component comp = (Component)c.getDelegatee();
        if (Events.isListened((Component)comp, (String)evtname, (boolean)true)) {
            return c;
        }
        return AuUtility.lookupEventTarget(c.getParent(), evtname);
    }

    static void setEssential(Map<String, Object> data, String key, Object obj) {
        AuUtility.setEssential(data, key, obj, false);
    }

    static void setEssential(Map<String, Object> data, String key, Object obj, boolean nullable) {
        if (obj == null && !nullable) {
            throw new AgentException("data of " + key + " is null");
        }
        data.put(key, AuUtility.toSafeJsonObject(obj));
    }

    static void setOptional(Map<String, Object> data, String key, Object obj) {
        if (obj == null) {
            return;
        }
        data.put(key, AuUtility.toSafeJsonObject(obj));
    }

    static void setReference(Map<String, Object> data, Component comp) {
        if (comp == null) {
            return;
        }
        data.put("reference", comp.getUuid());
    }

    private static Object toSafeJsonObject(Object obj) {
        if (obj instanceof Set) {
            return new ArrayList((Set)obj);
        }
        return obj;
    }

    public static List<AuResponse> convertToResponses(Map<String, Object> jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException("input object can't be null");
        }
        Object responses = jsonObject.get("rs");
        if (!(responses instanceof List)) {
            return null;
        }
        ArrayList<AuResponse> list = new ArrayList<AuResponse>();
        for (Object response : (List)responses) {
            List resp;
            if (response instanceof List && (resp = (List)response).size() == 2) {
                String cmd = resp.get(0).toString();
                Object data = resp.get(1);
                if (data instanceof List) {
                    list.add(new AuResponse(cmd, ((List)data).toArray()));
                    continue;
                }
                list.add(new AuResponse(cmd, data));
                continue;
            }
            return null;
        }
        return list;
    }

    public static Map<String, Object> parseAuResponseFromLayout(String raw) {
        JSONArray layoutCmds;
        block8: {
            String zkmxArgs;
            block7: {
                zkmxArgs = null;
                Document doc = Zsoup.parse((InputStream)new ByteArrayInputStream(raw.getBytes("utf-8")), (String)"UTF-8", (String)"", (org.zkoss.zsoup.parser.Parser)org.zkoss.zsoup.parser.Parser.xhtmlParser());
                Elements scripts = doc.getElementsByTag("script");
                for (Element script : scripts) {
                    String text = script.html().replaceAll("[\\n\\r]", "");
                    if (text.contains("zkmx(") && (zkmxArgs = AuUtility.fetchJavascriptFuntionArguments("zkmx", text)) != null) break;
                }
                if (zkmxArgs != null) break block7;
                return null;
            }
            String json = AuUtility.filterNonJSON(zkmxArgs);
            layoutCmds = (JSONArray)JSONValue.parseWithException((String)json);
            if (layoutCmds.size() >= 3) break block8;
            return null;
        }
        try {
            JSONArray rawAuCmds = (JSONArray)layoutCmds.get(2);
            JSONArray auCmds = new JSONArray();
            int i = 0;
            while (i < rawAuCmds.size()) {
                Object cmd = rawAuCmds.get(i);
                Object data = rawAuCmds.get(i + 1);
                if (!(data instanceof JSONArray)) {
                    data = JSONValue.parseWithException((String)data.toString());
                }
                JSONArray a = new JSONArray();
                a.add(cmd);
                a.add(data);
                auCmds.add((Object)a);
                i += 2;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rs", auCmds);
            return map;
        }
        catch (Exception e) {
            throw new ZatsException(e.getMessage(), (Throwable)e);
        }
    }

    public static String fetchJavascriptFuntionArguments(final String funcName, String code) {
        if (funcName == null || code == null) {
            return null;
        }
        Parser parser = new Parser();
        AstRoot root = parser.parse(code, null, 0);
        final AtomicReference target = new AtomicReference();
        root.visit(new NodeVisitor(){

            public boolean visit(AstNode node) {
                Name name;
                FunctionCall call;
                if (node instanceof FunctionCall && (node = (call = (FunctionCall)node).getTarget()) instanceof Name && funcName.equals((name = (Name)node).toSource())) {
                    target.set(call);
                    return false;
                }
                return true;
            }
        });
        FunctionCall call = (FunctionCall)target.get();
        if (call == null) {
            return null;
        }
        int lp = call.getLp();
        int rp = call.getRp();
        if (lp < 0 || rp < 0) {
            return null;
        }
        int start = lp + call.getAbsolutePosition() + 1;
        int end = rp + call.getAbsolutePosition();
        return "[" + code.substring(start, end) + "]";
    }

    public static String filterNonJSON(String json) {
        String prefix = "var tmp = ";
        StringBuilder src = new StringBuilder(prefix).append(json);
        Parser parser = new Parser();
        AstRoot root = parser.parse(src.toString(), null, 0);
        final ArrayList functions = new ArrayList();
        root.visit(new NodeVisitor(){

            public boolean visit(AstNode node) {
                if (node instanceof FunctionNode) {
                    functions.add((FunctionNode)node);
                }
                return true;
            }
        });
        Collections.sort(functions);
        int i = functions.size() - 1;
        while (i >= 0) {
            FunctionNode func = (FunctionNode)functions.get(i);
            int p = func.getAbsolutePosition();
            int len = func.getLength();
            src.replace(p, p + len, "''");
            --i;
        }
        return src.substring(prefix.length());
    }
}

