/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.emulator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.zkoss.zats.ZatsException;
import org.zkoss.zats.mimic.impl.emulator.Emulator;
import org.zkoss.zats.mimic.impl.emulator.EmulatorException;
import org.zkoss.zats.mimic.impl.emulator.JettyEmulator;

public class EmulatorBuilder {
    private static Logger logger = Logger.getLogger(EmulatorBuilder.class.getName());
    private String descriptor;
    private String contextPath = "/";
    private Resource webWebInf;
    private List<Resource> contentRoots = new ArrayList<Resource>();

    public EmulatorBuilder setWebInf(String webInfPathOrUrl) {
        this.webWebInf = new WebWebInfResource(this.toRecource(webInfPathOrUrl));
        return this;
    }

    public EmulatorBuilder setWebInf(URL webInf) {
        this.webWebInf = new WebWebInfResource(this.toRecource(webInf));
        return this;
    }

    public EmulatorBuilder addContentRoot(String contentRootPathOrUrl) {
        this.contentRoots.add(this.toRecource(contentRootPathOrUrl));
        return this;
    }

    public EmulatorBuilder addContentRoot(URL contentRoot) {
        this.contentRoots.add(this.toRecource(contentRoot));
        return this;
    }

    private Resource toRecource(String pathOrUrl) {
        try {
            return Resource.newResource((String)pathOrUrl);
        }
        catch (Exception x) {
            throw new EmulatorException(x.getMessage(), x);
        }
    }

    private Resource toRecource(URL url) {
        try {
            return Resource.newResource((URL)url);
        }
        catch (Exception x) {
            throw new EmulatorException(x.getMessage(), x);
        }
    }

    public EmulatorBuilder setDescriptor(String descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public EmulatorBuilder setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("null context path");
        }
        this.contextPath = contextPath;
        return this;
    }

    public Emulator create() {
        List<Resource> lr;
        if (this.webWebInf == null && this.contentRoots.size() == 0) {
            throw new ZatsException("no content root found");
        }
        if (this.webWebInf != null) {
            lr = new ArrayList<Resource>(this.contentRoots);
            lr.add(0, this.webWebInf);
        } else {
            lr = this.contentRoots;
        }
        return new JettyEmulator(lr.toArray(new Resource[lr.size()]), this.descriptor, this.contextPath);
    }

    static class WebWebInfResource
    extends Resource {
        Resource webInf;

        public WebWebInfResource(Resource webInf) {
            this.webInf = webInf;
        }

        public boolean isContainedIn(Resource r) throws MalformedURLException {
            URL wurl = this.webInf.getURL();
            URL rurl = r.getURL();
            if (wurl == null || rurl == null) {
                return false;
            }
            String wp = wurl.toExternalForm();
            String rp = rurl.toExternalForm();
            return rp.startsWith(wp);
        }

        public void release() {
        }

        public boolean exists() {
            return true;
        }

        public boolean isDirectory() {
            return true;
        }

        public long lastModified() {
            return -1L;
        }

        public long length() {
            return -1L;
        }

        public URL getURL() {
            URL wurl = this.webInf.getURL();
            if (wurl == null) {
                return null;
            }
            String wp = wurl.toExternalForm();
            if (wp.endsWith("/")) {
                wp = wp.substring(0, wp.length() - 1);
            }
            wp = wp.substring(0, wp.lastIndexOf(47) + 1);
            try {
                return new URL(wp);
            }
            catch (MalformedURLException e) {
                logger.warning(e.getMessage());
                return null;
            }
        }

        public File getFile() throws IOException {
            URL url = this.getURL();
            File f = url == null ? null : new File(url.getFile());
            return f;
        }

        public String getName() {
            try {
                File f = this.getFile();
                if (f != null) {
                    return f.getName();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
            return "Unknow";
        }

        public InputStream getInputStream() throws IOException {
            throw new IOException("cannot open input stream in virtual folder");
        }

        public OutputStream getOutputStream() throws IOException, SecurityException {
            throw new IOException("cannot open output stream in virtual folder");
        }

        public boolean delete() throws SecurityException {
            return false;
        }

        public boolean renameTo(Resource dest) throws SecurityException {
            return false;
        }

        public String[] list() {
            return new String[]{"WEB-INF"};
        }

        public Resource addPath(String path) throws IOException, MalformedURLException {
            if (path == null) {
                return null;
            }
            String p = URIUtil.canonicalPath((String)path);
            String string = p = p.startsWith("/") ? p.substring(1) : p;
            if (p.startsWith("WEB-INF/")) {
                p = p.substring("WEB-INF".length());
                return this.webInf.addPath(p);
            }
            return this.toNonExist(path);
        }

        Resource toNonExist(String path) {
            String tmpDir = System.getProperty("java.io.tmpdir", ".");
            try {
                return new FileResource(new File(tmpDir, "zats/non_exist/" + path).toURL());
            }
            catch (Exception x) {
                logger.warning(x.getMessage());
                throw new EmulatorException(x.getMessage(), x);
            }
        }

        public String toString() {
            URL url = this.getURL();
            return url == null ? super.toString() : url.toExternalForm();
        }
    }
}

