/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.emulator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.zkoss.zats.mimic.impl.emulator.Emulator;
import org.zkoss.zats.mimic.impl.emulator.EmulatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyEmulator
implements Emulator {
    private static Logger logger = Logger.getLogger(JettyEmulator.class.getName());
    private ReentrantLock lock;
    private Server server;
    private int port;
    private String address;
    private String contextPath;
    private ServletContext context;
    private String sessionId;
    private Map<String, Object> sessionAttributes;
    private Map<String, Object> requestAttributes;
    private Map<String, String[]> requestParameters;
    private File tmpDir;

    public JettyEmulator(Resource contentRoot, String descriptor, String contextPath) {
        this(new Resource[]{contentRoot}, descriptor, contextPath);
    }

    public JettyEmulator(Resource[] contentRoots, String descriptor, String contextPath) {
        if (contentRoots == null || contentRoots.length <= 0) {
            throw new IllegalArgumentException("contentRoots can't be null.");
        }
        this.lock = new ReentrantLock(true);
        this.requestAttributes = new HashMap<String, Object>();
        this.requestParameters = new HashMap<String, String[]>();
        this.contextPath = contextPath == null ? "/" : contextPath;
        try {
            this.server = new Server(new InetSocketAddress(this.getHost(), 0));
            WebAppContext contextHandler = new WebAppContext();
            ResourceCollection resourceCollection = new ResourceCollection(contentRoots);
            contextHandler.setBaseResource((Resource)resourceCollection);
            if (descriptor != null) {
                contextHandler.setDescriptor(descriptor);
            }
            contextHandler.setContextPath(this.contextPath);
            contextHandler.setParentLoaderPriority(true);
            File tmpFile = File.createTempFile("jetty.", ".tmp");
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            this.tmpDir = new File(tmpFile.getParent(), String.valueOf(tmpFile.getName()) + ".dir");
            this.tmpDir.mkdirs();
            if (this.tmpDir.exists()) {
                contextHandler.setTempDirectory(this.tmpDir);
            } else {
                this.tmpDir = null;
            }
            HandlerCollection handlers = new HandlerCollection();
            handlers.addHandler((Handler)new BeforeHandler());
            handlers.addHandler((Handler)contextHandler);
            handlers.addHandler((Handler)new AfterHandler());
            this.server.setHandler((Handler)handlers);
            final ArrayBlockingQueue queue = new ArrayBlockingQueue(1, true);
            contextHandler.addLifeCycleListener((LifeCycle.Listener)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{LifeCycle.Listener.class}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("lifeCycleStarted".equals(method.getName())) {
                        queue.add(method.getName());
                    }
                    return null;
                }
            }));
            this.server.start();
            queue.take();
            Connector[] connectorArray = this.server.getConnectors();
            int n = connectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Connector c = connectorArray[n2];
                if (c.getLocalPort() > 0) {
                    this.port = c.getLocalPort();
                    break;
                }
                ++n2;
            }
            this.context = this.getWrappedContext(contextHandler.getServletHandler().getServletContext());
        }
        catch (Exception e) {
            throw new EmulatorException("", e);
        }
    }

    @Override
    public void close() {
        List<File> resources;
        block8: {
            if (this.server == null) {
                return;
            }
            try {
                try {
                    this.server.stop();
                    this.server.destroy();
                }
                catch (Throwable throwable) {
                    this.server = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.server = null;
                throw throwable;
            }
            this.server = null;
        }
        if (this.tmpDir.getName().startsWith("jetty.") && (resources = this.depthFirstSearch(this.tmpDir)).size() < 10) {
            String tmpPath = this.tmpDir.getAbsolutePath();
            for (File r : resources) {
                String targetPath = r.getAbsolutePath();
                if (!targetPath.startsWith(tmpPath)) continue;
                r.delete();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("delete resource: " + targetPath);
            }
        }
    }

    private List<File> depthFirstSearch(File dir) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        LinkedList<File> targetSquence = new LinkedList<File>();
        LinkedList<File> stack = new LinkedList<File>();
        stack.add(dir);
        while (!stack.isEmpty()) {
            File item = (File)stack.removeFirst();
            if (item.isDirectory()) {
                File[] fileArray = item.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    stack.addFirst(child);
                    ++n2;
                }
            }
            targetSquence.addFirst(item);
        }
        return targetSquence;
    }

    @Override
    public String getHost() {
        return "127.0.0.1";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            String cp = this.getContextPath();
            if (cp.endsWith("/")) {
                cp = cp.substring(0, cp.length() - 1);
            }
            this.address = MessageFormat.format("http://{0}:{1,number,#}{2}", this.getHost(), this.getPort(), cp);
        }
        return this.address;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public Map<String, Object> getRequestAttributes() {
        this.lock.lock();
        try {
            Map<String, Object> map = this.requestAttributes;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<String, String[]> getRequestParameters() {
        this.lock.lock();
        try {
            Map<String, String[]> map = this.requestParameters;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<String, Object> getSessionAttributes() {
        this.lock.lock();
        try {
            Map<String, Object> map = this.sessionAttributes;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getSessionId() {
        this.lock.lock();
        try {
            String string = this.sessionId;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ServletContext getWrappedContext(final ServletContext delegate) {
        return (ServletContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!method.getName().startsWith("getAttribute")) {
                    return method.invoke((Object)delegate, args);
                }
                JettyEmulator.this.lock.lock();
                try {
                    Object object = method.invoke((Object)delegate, args);
                    return object;
                }
                finally {
                    JettyEmulator.this.lock.unlock();
                }
            }
        });
    }

    private class AfterHandler
    extends AbstractHandler {
        private AfterHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                String name;
                Enumeration names;
                JettyEmulator.this.requestParameters = new HashMap(request.getParameterMap());
                HttpSession session = request.getSession(false);
                JettyEmulator.this.sessionId = session != null ? session.getId() : null;
                JettyEmulator.this.sessionAttributes = new HashMap();
                if (session != null) {
                    names = session.getAttributeNames();
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        JettyEmulator.this.sessionAttributes.put(name, session.getAttribute(name));
                    }
                }
                JettyEmulator.this.requestAttributes = new HashMap();
                names = request.getAttributeNames();
                while (names.hasMoreElements()) {
                    name = (String)names.nextElement();
                    JettyEmulator.this.requestAttributes.put(name, request.getAttribute(name));
                }
            }
            finally {
                JettyEmulator.this.lock.unlock();
            }
        }
    }

    private class BeforeHandler
    extends AbstractHandler {
        private BeforeHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            JettyEmulator.this.lock.lock();
        }
    }
}

