/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.SizeAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.event.MinimizeEvent;
import org.zkoss.zk.ui.event.SizeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSizeAgentBuilder
implements OperationAgentBuilder<ComponentAgent, SizeAgent> {
    @Override
    public Class<SizeAgent> getOperationClass() {
        return SizeAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSizeAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements SizeAgent {
        public AbstractSizeAgentImpl(ComponentAgent target) {
            super(target);
        }

        protected abstract boolean isMaximizable();

        protected abstract boolean isMinimizable();

        protected abstract boolean isSizable();

        protected abstract int getMinwidth();

        protected abstract int getMinheight();

        @Override
        public void maximize(boolean maximized) {
            if (!this.isMaximizable()) {
                throw new AgentException(this.target + " is not maximizable");
            }
            HtmlBasedComponent comp = ((ComponentAgent)this.target).as(HtmlBasedComponent.class);
            String cmd = "onMaximize";
            MaximizeEvent event = new MaximizeEvent(cmd, (Component)comp, "", "", comp.getWidth(), comp.getHeight(), maximized);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }

        @Override
        public void minimize(boolean minimized) {
            if (!this.isMinimizable()) {
                throw new AgentException(this.target + " is not minimizable");
            }
            HtmlBasedComponent comp = ((ComponentAgent)this.target).as(HtmlBasedComponent.class);
            String cmd = "onMinimize";
            MinimizeEvent event = new MinimizeEvent(cmd, (Component)comp, "", "", comp.getWidth(), comp.getHeight(), minimized);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }

        @Override
        public void resize(int width, int height) {
            if (!this.isSizable()) {
                throw new AgentException(this.target + " is not sizable");
            }
            if (width < 0 && height < 0) {
                return;
            }
            HtmlBasedComponent comp = ((ComponentAgent)this.target).as(HtmlBasedComponent.class);
            try {
                if (width < 0) {
                    String widthStr = comp.getWidth();
                    if (widthStr == null || widthStr.length() <= 0) {
                        widthStr = String.valueOf(this.getMinwidth()) + "px";
                    }
                    width = Integer.parseInt(widthStr.substring(0, widthStr.length() - 2));
                }
                if (height < 0) {
                    String heightStr = comp.getHeight();
                    if (heightStr == null || heightStr.length() <= 0) {
                        heightStr = String.valueOf(this.getMinheight()) + "px";
                    }
                    height = Integer.parseInt(heightStr.substring(0, heightStr.length() - 2));
                }
            }
            catch (Exception e) {
                throw new AgentException(e.getMessage(), e);
            }
            String cmd = "onSize";
            SizeEvent event = new SizeEvent(cmd, (Component)comp, String.valueOf(width) + "px", String.valueOf(height) + "px", 0);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }
    }
}

