/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.IO;
import org.zkoss.lang.Strings;
import org.zkoss.zats.common.util.MultiPartOutputStream;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.Util;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.UploadAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.sys.DesktopCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUploadAgentBuilder
implements OperationAgentBuilder<ComponentAgent, UploadAgent> {
    private static final Logger logger = Logger.getLogger(AbstractUploadAgentBuilder.class.getName());

    @Override
    public Class<UploadAgent> getOperationClass() {
        return UploadAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractUploadAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements UploadAgent {
        private HttpURLConnection conn;
        private MultiPartOutputStream multipartStream;
        private boolean isMultiple;

        public AbstractUploadAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void upload(File file, String contentType) {
            if (file == null) {
                throw new NullPointerException("file can't be null.");
            }
            BufferedInputStream is = null;
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    this.upload(file.getName(), is, contentType);
                }
                catch (IOException e) {
                    throw new AgentException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Util.close(is);
                throw throwable;
            }
            Util.close(is);
        }

        protected abstract String getUploadFlag();

        @Override
        public void upload(String fileName, InputStream content, String contentType) {
            if (fileName == null) {
                throw new NullPointerException("file name can't be null.");
            }
            if (content == null) {
                throw new NullPointerException("content stream can't be null.");
            }
            if (this.multipartStream == null) {
                String flag = this.getUploadFlag();
                if (flag == null || flag.length() == 0) {
                    throw new AgentException("upload feature doesn't turn on.");
                }
                HashMap<String, String> attr = new HashMap<String, String>();
                String[] stringArray = flag.split("\\s*,\\s*");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.trim().length() > 0) {
                        String[] tokens = token.split("[\\s=]+");
                        if (tokens.length == 1) {
                            attr.put("", tokens[0]);
                        } else if (tokens.length >= 2) {
                            attr.put(tokens[0], tokens[1]);
                        }
                    }
                    ++n2;
                }
                String value = (String)attr.get("");
                if ("false".equals(value)) {
                    throw new AgentException("upload feature doesn't turn on.");
                }
                this.isMultiple = Boolean.parseBoolean((String)attr.get("multiple"));
                try {
                    String param = "?uuid={0}&dtid={1}&sid=0&maxsize=undefined";
                    param = MessageFormat.format(param, ((ComponentAgent)this.target).getUuid(), ((ComponentAgent)this.target).getDesktop().getId());
                    String boundary = Util.generateRandomString();
                    ClientCtrl cc = (ClientCtrl)((Object)this.getClient());
                    this.conn = cc.getConnection("/zkau/upload" + param, "POST");
                    this.conn.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    this.conn.setDoInput(true);
                    this.conn.setDoOutput(true);
                    OutputStream os = this.conn.getOutputStream();
                    this.multipartStream = new MultiPartOutputStream(os, boundary);
                }
                catch (IOException e) {
                    this.clean();
                    throw new AgentException(e.getMessage(), e);
                }
            } else if (!this.isMultiple) {
                throw new AgentException("multiple upload feature doesn't turn on.");
            }
            try {
                int b;
                String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"{0}\"";
                contentDisposition = MessageFormat.format(contentDisposition, fileName);
                String[] headers = new String[]{contentDisposition};
                this.multipartStream.startPart(contentType != null ? contentType : "application/octet-stream", headers);
                while ((b = content.read()) >= 0) {
                    this.multipartStream.write(b);
                }
            }
            catch (IOException e) {
                this.clean();
                throw new AgentException(e.getMessage(), e);
            }
        }

        @Override
        public void finish() {
            if (this.multipartStream == null) {
                return;
            }
            this.clean();
            int key = ((DesktopCtrl)((ComponentAgent)this.target).getDesktop().getDelegatee()).getNextKey() - 1;
            String contentId = Strings.encode((StringBuffer)new StringBuffer(12).append("z__ul_"), (int)key).toString();
            String cmd = "updateResult";
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            Event event = new Event(cmd, (Component)((ComponentAgent)this.target).getDelegatee());
            Map<String, Object> data = EventDataManager.getInstance().build(event);
            data.put("wid", ((ComponentAgent)this.target).getUuid());
            data.put("contentId", contentId);
            data.put("sid", "0");
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).flush(desktopId);
        }

        private void clean() {
            Util.close((Closeable)this.multipartStream);
            this.multipartStream = null;
            InputStream is = null;
            try {
                try {
                    String respMsg = this.conn.getResponseMessage();
                    is = this.conn.getInputStream();
                    String resp = IO.toString((InputStream)is);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("response message: " + respMsg);
                        logger.finest("response content: " + resp);
                    }
                }
                catch (IOException e) {
                    throw new AgentException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Util.close(is);
                this.conn = null;
                throw throwable;
            }
            Util.close(is);
            this.conn = null;
        }
    }
}

