/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.IO;
import org.zkoss.lang.Strings;
import org.zkoss.zats.common.util.MultiPartOutputStream;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.Util;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.UploadAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.sys.DesktopCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogUploadAgentBuilder
implements OperationAgentBuilder<DesktopAgent, UploadAgent> {
    private static final Logger logger = Logger.getLogger(DialogUploadAgentBuilder.class.getName());

    @Override
    public Class<UploadAgent> getOperationClass() {
        return UploadAgent.class;
    }

    @Override
    public UploadAgent getOperation(DesktopAgent target) {
        return new UploadAgentImpl(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UploadAgentImpl
    extends AgentDelegator<DesktopAgent>
    implements UploadAgent {
        private int sid;

        public UploadAgentImpl(DesktopAgent target) {
            super(target);
        }

        @Override
        public void upload(File file, String contentType) {
            if (file == null) {
                throw new NullPointerException("file can't be null.");
            }
            BufferedInputStream is = null;
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    this.upload(file.getName(), is, contentType);
                }
                catch (IOException e) {
                    throw new AgentException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Util.close(is);
                throw throwable;
            }
            Util.close(is);
        }

        @Override
        public void upload(String fileName, InputStream content, String contentType) {
            if (fileName == null) {
                throw new NullPointerException("file name can't be null.");
            }
            if (content == null) {
                throw new NullPointerException("content stream can't be null.");
            }
            DesktopAgent desktop = (DesktopAgent)this.target;
            ComponentAgent dialog = desktop.query("uploaddlg");
            ComponentAgent fileupload = desktop.query("uploaddlg fileupload");
            if (dialog == null || fileupload == null) {
                throw new AgentException("There is no dialog for uploading.");
            }
            OutputStream os = null;
            InputStream is = null;
            try {
                try {
                    int b;
                    String param = "?uuid={0}&dtid={1}&sid={2}&maxsize=undefined";
                    param = MessageFormat.format(param, fileupload.getUuid(), desktop.getId(), String.valueOf(this.sid));
                    String boundary = Util.generateRandomString();
                    ClientCtrl cc = (ClientCtrl)((Object)this.getClient());
                    HttpURLConnection conn = cc.getConnection("/zkau/upload" + param, "POST");
                    conn.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    os = conn.getOutputStream();
                    MultiPartOutputStream multipartStream = new MultiPartOutputStream(os, boundary);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("desktop: " + desktop.getId());
                        logger.finest("upload URL: " + conn.getURL().toString());
                    }
                    String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"{0}\"";
                    contentDisposition = MessageFormat.format(contentDisposition, fileName);
                    String[] headers = new String[]{contentDisposition};
                    multipartStream.startPart(contentType != null ? contentType : "application/octet-stream", headers);
                    while ((b = content.read()) >= 0) {
                        multipartStream.write(b);
                    }
                    Util.close((Closeable)multipartStream);
                    String respMsg = conn.getResponseMessage();
                    is = conn.getInputStream();
                    String resp = IO.toString((InputStream)is);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("response message: " + respMsg);
                        logger.finest("response content: " + resp);
                    }
                }
                catch (IOException e) {
                    throw new AgentException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Util.close(os);
                Util.close(is);
                throw throwable;
            }
            Util.close(os);
            Util.close(is);
            int key = ((DesktopCtrl)desktop.getDelegatee()).getNextKey() - 1;
            String contentId = Strings.encode((StringBuffer)new StringBuffer(12).append("z__ul_"), (int)key).toString();
            String cmd = "updateResult";
            String desktopId = desktop.getId();
            Event event = new Event(cmd, (Component)fileupload.getDelegatee());
            Map<String, Object> data = EventDataManager.getInstance().build(event);
            data.put("wid", fileupload.getUuid());
            data.put("contentId", contentId);
            data.put("sid", String.valueOf(this.sid++));
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, fileupload.getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }

        @Override
        public void finish() {
            DesktopAgent desktop = (DesktopAgent)this.target;
            ComponentAgent dialog = desktop.query("uploaddlg");
            if (dialog == null) {
                throw new AgentException("There is no dialog for uploading.");
            }
            String desktopId = desktop.getId();
            Event event = new Event("onClose", (Component)dialog.getDelegatee());
            Map<String, Object> data = EventDataManager.getInstance().build(event);
            data.put("", true);
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, dialog.getUuid(), "onClose", data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
            this.sid = 0;
        }
    }
}

