/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.au.AuUtility;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.KeyStrokeAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.KeyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericKeyStrokeAgentBuilder
implements OperationAgentBuilder<ComponentAgent, KeyStrokeAgent> {
    private static final int ENTER = 13;
    private static final int ESC = 27;

    @Override
    public KeyStrokeAgent getOperation(ComponentAgent target) {
        return new KeyStrokeAgentImpl(target);
    }

    @Override
    public Class<KeyStrokeAgent> getOperationClass() {
        return KeyStrokeAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyStrokeAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements KeyStrokeAgent {
        public KeyStrokeAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void stroke(String key) {
            if ((key = key.toLowerCase().trim()).startsWith("#")) {
                if ("#enter".equals(key)) {
                    this.doOnOK();
                    return;
                }
                if ("#esc".equals(key)) {
                    this.doOnCancel();
                    return;
                }
            }
            this.doOnCtrlKey(key);
        }

        private void doOnCtrlKey(String key) {
            ComponentAgent et = AuUtility.lookupEventTarget((ComponentAgent)this.target, "onCtrlKey");
            if (et == null) {
                return;
            }
            int keyCode = -1;
            int which = 0;
            boolean ctrlKey = false;
            boolean shiftKey = false;
            boolean altKey = false;
            int len = key.length();
            int j = 0;
            while (j < len) {
                if (keyCode >= 0) {
                    throw new AgentException("allow one key code only: " + key);
                }
                char cc = key.charAt(j);
                switch (cc) {
                    case '$': 
                    case '@': 
                    case '^': {
                        if (which != 0) {
                            throw new AgentException("Combination of Shift, Alt and Ctrl not supported: " + key);
                        }
                        which = cc == '^' ? 1 : (cc == '@' ? 2 : 3);
                        switch (which) {
                            case 1: {
                                ctrlKey = true;
                                break;
                            }
                            case 2: {
                                altKey = true;
                                break;
                            }
                            case 3: {
                                shiftKey = true;
                            }
                        }
                        break;
                    }
                    case '#': {
                        int k = j + 1;
                        while (k < len) {
                            char c2 = key.charAt(k);
                            if (!(c2 <= 'z' && c2 >= 'a' || c2 <= '9' && c2 >= '0')) break;
                            ++k;
                        }
                        if (k == j + 1) {
                            throw new AgentException("Unexpected character " + cc + " in " + key);
                        }
                        String s = key.substring(j + 1, k);
                        if ("pgup".equals(s)) {
                            keyCode = 33;
                        } else if ("pgdn".equals(s)) {
                            keyCode = 34;
                        } else if ("end".equals(s)) {
                            keyCode = 35;
                        } else if ("home".equals(s)) {
                            keyCode = 36;
                        } else if ("left".equals(s)) {
                            keyCode = 37;
                        } else if ("up".equals(s)) {
                            keyCode = 38;
                        } else if ("right".equals(s)) {
                            keyCode = 39;
                        } else if ("down".equals(s)) {
                            keyCode = 40;
                        } else if ("ins".equals(s)) {
                            keyCode = 45;
                        } else if ("del".equals(s)) {
                            keyCode = 46;
                        } else if ("bak".equals(s)) {
                            keyCode = 8;
                        } else if (s.length() > 1 && s.charAt(0) == 'f') {
                            int v = Integer.parseInt(s.substring(1));
                            if (v == 0 || v > 12) {
                                throw new AgentException("Unsupported function key: #f" + v);
                            }
                            keyCode = (char)(112 + v - 1);
                        } else {
                            throw new AgentException("Unknown #" + s + " in " + key);
                        }
                        which = 0;
                        j = k - 1;
                        break;
                    }
                    default: {
                        if (which == 0 || (cc > 'z' || cc < 'a') && (cc > '9' || cc < '0')) {
                            throw new AgentException("Unexpected character " + cc + " in " + key);
                        }
                        if (which == 3) {
                            throw new AgentException("$a - $z not supported (found in " + key + "). Allowed: $#f1, $#home and so on.");
                        }
                        keyCode = Character.toUpperCase(cc);
                        which = 0;
                    }
                }
                ++j;
            }
            if (keyCode < 0) {
                throw new AgentException("Code code not found: " + key);
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onCtrlKey";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new KeyEvent(cmd, (Component)et.getDelegatee(), keyCode, ctrlKey, shiftKey, altKey, (Component)((ComponentAgent)this.target).getDelegatee()));
            ((ClientCtrl)((Object)et.getClient())).postUpdate(desktopId, et.getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).flush(desktopId);
        }

        private void doOnCancel() {
            ComponentAgent et = AuUtility.lookupEventTarget((ComponentAgent)this.target, "onCancel");
            if (et == null) {
                return;
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onCancel";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new KeyEvent(cmd, (Component)et.getDelegatee(), 27, false, false, false, (Component)((ComponentAgent)this.target).getDelegatee()));
            ((ClientCtrl)((Object)et.getClient())).postUpdate(desktopId, et.getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).flush(desktopId);
        }

        private void doOnOK() {
            ComponentAgent et = AuUtility.lookupEventTarget((ComponentAgent)this.target, "onOK");
            if (et == null) {
                return;
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onOK";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new KeyEvent(cmd, (Component)et.getDelegatee(), 13, false, false, false, (Component)((ComponentAgent)this.target).getDelegatee()));
            ((ClientCtrl)((Object)et.getClient())).postUpdate(desktopId, et.getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).flush(desktopId);
        }
    }
}

