/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.RenderAgent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.RenderEvent;
import org.zkoss.zul.impl.LoadStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridRenderAgentBuilder
implements OperationAgentBuilder<ComponentAgent, RenderAgent> {
    static boolean ignoreIsLoaded = false;

    @Override
    public RenderAgent getOperation(ComponentAgent target) {
        if (!target.is(Grid.class)) {
            throw new AgentException("target " + target + " cannot transfer to Grid");
        }
        return new RendererAgentImpl(target);
    }

    @Override
    public Class<RenderAgent> getOperationClass() {
        return RenderAgent.class;
    }

    private static boolean isLoaded(Row r) {
        Object ctrl = r.getExtraCtrl();
        if (ctrl instanceof LoadStatus) {
            return ((LoadStatus)ctrl).isLoaded();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RendererAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements RenderAgent {
        public RendererAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void render(int x, int y) {
            Grid grid = ((ComponentAgent)this.target).as(Grid.class);
            Rows rows = grid.getRows();
            if (rows == null) {
                return;
            }
            List children = rows.getChildren();
            if (x == -1) {
                x = 0;
            }
            if (y == -1) {
                y = rows.getChildren().size() - 1;
            }
            ArrayList<String> ids = new ArrayList<String>();
            while (x <= y) {
                Row r;
                if ((r = (Row)children.get(x++)) == null || GridRenderAgentBuilder.isLoaded(r)) continue;
                ids.add(r.getUuid());
            }
            if (ids.size() == 0) {
                return;
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onRender";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new RenderEvent(cmd, new HashSet(ids)));
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }
    }
}

