/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.SizeAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.event.ColSizeEvent;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.impl.HeadersElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeaderSizeAgentBuilder
implements OperationAgentBuilder<ComponentAgent, SizeAgent> {
    HeaderSizeAgentBuilder() {
    }

    @Override
    public Class<SizeAgent> getOperationClass() {
        return SizeAgent.class;
    }

    @Override
    public SizeAgent getOperation(ComponentAgent target) {
        ComponentAgent parent = target.getParent();
        if (parent != null && parent.is(HeadersElement.class)) {
            return new HeaderSizeAgentImpl(target);
        }
        throw new AgentException(target + " doesn't support resize operation");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HeaderSizeAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements SizeAgent {
        public HeaderSizeAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void maximize(boolean maximized) {
            throw new AgentException(this.target + " doesn't support maximized operation");
        }

        @Override
        public void minimize(boolean minimized) {
            throw new AgentException(this.target + " doesn't support minimized operation");
        }

        @Override
        public void resize(int width, int height) {
            if (width < 0) {
                return;
            }
            HeaderElement column = ((ComponentAgent)this.target).as(HeaderElement.class);
            HeadersElement head = ((ComponentAgent)this.target).getParent().as(HeadersElement.class);
            List children = head.getChildren();
            int index = children.indexOf(column);
            String[] widths = new String[children.size()];
            int i = 0;
            while (i < widths.length) {
                widths[i] = ((HeaderElement)children.get(i)).getWidth();
                if (widths[i] == null || widths[i].length() <= 0) {
                    widths[i] = "200px";
                }
                ++i;
            }
            widths[index] = String.valueOf(width) + "px";
            if (widths[index].equals(column.getWidth())) {
                return;
            }
            Component container = head.getParent();
            String innerWidth = null;
            try {
                Method method = container.getClass().getMethod("getInnerWidth", new Class[0]);
                innerWidth = method.invoke((Object)container, new Object[0]).toString();
            }
            catch (Exception e) {
                new AgentException("unexpected exception", e);
            }
            ClientCtrl cc = (ClientCtrl)((Object)((ComponentAgent)this.target).getClient());
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onInnerWidth";
            Map<String, Object> data = EventDataManager.getInstance().build(new Event(cmd));
            data.put("", innerWidth);
            cc.postUpdate(desktopId, container.getUuid(), cmd, data, false);
            cmd = "onColSize";
            ColSizeEvent event = new ColSizeEvent(cmd, (Component)head, index, (Component)column, widths, 0);
            data = EventDataManager.getInstance().build((Event)event);
            data.put("widths", widths);
            cc.postUpdate(desktopId, head.getUuid(), cmd, data, false);
            cc.flush(desktopId);
        }
    }
}

