/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.RenderAgent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.event.RenderEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListboxRenderAgentBuilder
implements OperationAgentBuilder<ComponentAgent, RenderAgent> {
    @Override
    public RenderAgent getOperation(ComponentAgent target) {
        if (!target.is(Listbox.class)) {
            throw new AgentException("target " + target + " cannot transfer to Listbox");
        }
        return new RendererAgentImpl(target);
    }

    @Override
    public Class<RenderAgent> getOperationClass() {
        return RenderAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RendererAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements RenderAgent {
        public RendererAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void render(int x, int y) {
            Listbox listbox = ((ComponentAgent)this.target).as(Listbox.class);
            if (x == -1) {
                x = 0;
            }
            if (y == -1) {
                y = listbox.getItemCount() - 1;
            }
            ArrayList<String> ids = new ArrayList<String>();
            while (x <= y) {
                Listitem item;
                if ((item = listbox.getItemAtIndex(x++)) == null || item.isLoaded()) continue;
                ids.add(item.getUuid());
            }
            if (ids.size() == 0) {
                return;
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onRender";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new RenderEvent(cmd, new HashSet(ids)));
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }
    }
}

