/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.PagingAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.PagingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingAgentBuilder
implements OperationAgentBuilder<ComponentAgent, PagingAgent> {
    @Override
    public PagingAgent getOperation(ComponentAgent target) {
        return new PagingAgentImpl(target);
    }

    @Override
    public Class<PagingAgent> getOperationClass() {
        return PagingAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PagingAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements PagingAgent {
        public PagingAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void moveTo(int pageIndex) {
            Paging paging = (Paging)((ComponentAgent)this.target).getDelegatee();
            if (pageIndex < 0 || pageIndex > paging.getPageCount() - 1) {
                throw new AgentException("Page index out of bound (0-" + (paging.getPageCount() - 1) + ") : " + pageIndex);
            }
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onPaging";
            Map<String, Object> data = EventDataManager.getInstance().build((Event)new PagingEvent(cmd, (Component)paging, pageIndex));
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, paging.getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }
    }
}

