/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation;

import java.math.BigDecimal;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.InputAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.ScrollEvent;
import org.zkoss.zul.Slider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliderInputAgentBuilder
implements OperationAgentBuilder<ComponentAgent, InputAgent> {
    @Override
    public Class<InputAgent> getOperationClass() {
        return InputAgent.class;
    }

    @Override
    public InputAgent getOperation(ComponentAgent agent) {
        return new InputAgentImpl(agent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InputAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements InputAgent {
        public InputAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void input(Object raw) {
            if (raw == null) {
                throw new AgentException("value can't be null");
            }
            int value = -1;
            if (raw instanceof Number) {
                if (raw instanceof Double || raw instanceof Float || raw instanceof BigDecimal) {
                    throw new AgentException("value can't be float type: " + raw.getClass().getName());
                }
                value = ((Number)raw).intValue();
            } else if (raw instanceof String) {
                String text = raw.toString().trim();
                try {
                    value = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    throw new AgentException("value must be a valid integer string: " + text, e);
                }
            } else {
                throw new AgentException("unsupport type of value: " + raw.getClass().getName());
            }
            if (value < 0 || value > ((ComponentAgent)this.target).as(Slider.class).getMaxpos()) {
                throw new AgentException("value is out of bounds: " + value);
            }
            String cmd = "onScroll";
            ScrollEvent event = new ScrollEvent(cmd, (Component)this.getDelegatee(), value);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            ((ClientCtrl)((Object)this.getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).flush(desktopId);
        }

        @Override
        public void type(String value) {
            throw new AgentException(this.target + " doesn't support type operation");
        }

        @Override
        public void typing(String value) {
            throw new AgentException(this.target + " doesn't support typing operation");
        }

        @Override
        public void select(int start, int end) {
            throw new AgentException(this.target + " doesn't support select operation");
        }
    }
}

