/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation.input;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.InputAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SelectionEvent;
import org.zkoss.zul.impl.InputElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInputAgentBuilder
implements OperationAgentBuilder<ComponentAgent, InputAgent> {
    protected static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    protected static final String DEFAULT_TIME_FORMAT = "HH:mm";

    @Override
    public Class<InputAgent> getOperationClass() {
        return InputAgent.class;
    }

    protected static Date parseDate(String format, String value) {
        try {
            return new SimpleDateFormat(format).parse(value);
        }
        catch (Exception e) {
            throw new AgentException(e.getMessage(), e);
        }
    }

    protected static String formatDate(String format, Date value) {
        try {
            return new SimpleDateFormat(format).format(value);
        }
        catch (Exception e) {
            throw new AgentException(e.getMessage(), e);
        }
    }

    protected static Number parseNumber(String format, String value) {
        try {
            return new DecimalFormat(format).parse(value);
        }
        catch (Exception e) {
            throw new AgentException(e.getMessage(), e);
        }
    }

    protected static String formatNumber(String format, Number number) {
        try {
            return new DecimalFormat(format).format(number);
        }
        catch (Exception e) {
            throw new AgentException(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractInputAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements InputAgent {
        public AbstractInputAgentImpl(ComponentAgent target) {
            super(target);
        }

        protected abstract void putValue(ComponentAgent var1, String var2, Map<String, Object> var3);

        protected abstract String toRawString(ComponentAgent var1, Object var2);

        @Override
        public void input(Object value) {
            this.type(this.toRawString((ComponentAgent)this.target, value));
        }

        @Override
        public void type(String value) {
            try {
                ClientCtrl cctrl = (ClientCtrl)((Object)((ComponentAgent)this.target).getClient());
                String cmd = "onChange";
                InputEvent event = new InputEvent(cmd, (Component)((ComponentAgent)this.target).getDelegatee(), value, null);
                Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
                this.putValue((ComponentAgent)this.target, value, data);
                String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
                cctrl.postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
                cctrl.flush(desktopId);
            }
            catch (Exception e) {
                throw new AgentException("value \"" + value + "\" is invalid for the component: " + this.target, e);
            }
        }

        @Override
        public void typing(String value) {
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onChanging";
            InputEvent event = new InputEvent(cmd, (Component)((ComponentAgent)this.target).getDelegatee(), value, null);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }

        @Override
        public void select(int start, int end) {
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            String cmd = "onSelection";
            String selectedText = ((InputElement)((ComponentAgent)this.target).getDelegatee()).getText().substring(start, end);
            SelectionEvent event = new SelectionEvent(cmd, (Component)((ComponentAgent)this.target).getDelegatee(), start, end, selectedText);
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            ((ClientCtrl)((Object)((ComponentAgent)this.target).getClient())).postUpdate(desktopId, ((ComponentAgent)this.target).getUuid(), cmd, data, false);
            ((ClientCtrl)((Object)this.getClient())).flush(desktopId);
        }
    }
}

