/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation.input;

import java.math.BigInteger;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.operation.input.AbstractInputAgentBuilder;
import org.zkoss.zats.mimic.operation.InputAgent;
import org.zkoss.zul.impl.FormatInputElement;

public class IntegerStringInputAgentBuilder
extends AbstractInputAgentBuilder {
    public InputAgent getOperation(ComponentAgent agent) {
        return new InputAgentImpl(agent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InputAgentImpl
    extends AbstractInputAgentBuilder.AbstractInputAgentImpl {
        public InputAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        protected void putValue(ComponentAgent target, String raw, Map<String, Object> data) {
            if (Strings.isBlank((String)raw)) {
                data.put("value", null);
            } else {
                Object comp = target.getDelegatee();
                String f = ((FormatInputElement)comp).getFormat();
                if (f != null) {
                    data.put("value", IntegerStringInputAgentBuilder.parseNumber(f, raw.trim()).toString());
                } else {
                    data.put("value", new BigInteger(raw.trim()).toString());
                }
            }
        }

        @Override
        protected String toRawString(ComponentAgent target, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                Object comp = target.getDelegatee();
                String f = ((FormatInputElement)comp).getFormat();
                if (f != null) {
                    return IntegerStringInputAgentBuilder.formatNumber(f, (Number)value);
                }
                return value.toString();
            }
            throw new IllegalArgumentException("unsupported value type " + value.getClass());
        }
    }
}

