/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation.input;

import java.util.Date;
import java.util.Map;
import org.zkoss.json.JSONs;
import org.zkoss.lang.Strings;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.operation.input.AbstractInputAgentBuilder;
import org.zkoss.zats.mimic.operation.InputAgent;
import org.zkoss.zul.impl.FormatInputElement;

public class TimeInputAgentBuilder
extends AbstractInputAgentBuilder {
    public InputAgent getOperation(ComponentAgent agent) {
        return new InputAgentImpl(agent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InputAgentImpl
    extends AbstractInputAgentBuilder.AbstractInputAgentImpl {
        public InputAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        protected void putValue(ComponentAgent target, String raw, Map<String, Object> data) {
            if (Strings.isBlank((String)raw)) {
                data.put("value", null);
            } else {
                Object comp = target.getDelegatee();
                String f = ((FormatInputElement)comp).getFormat();
                Date time = TimeInputAgentBuilder.parseDate(f == null ? "HH:mm" : f, raw.trim());
                data.put("value", JSONs.d2j((Date)time));
                data.put("z_type_value", "Date");
            }
        }

        @Override
        protected String toRawString(ComponentAgent target, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                Object comp = target.getDelegatee();
                String f = ((FormatInputElement)comp).getFormat();
                return TimeInputAgentBuilder.formatDate(f == null ? "yyyy/MM/dd" : f, (Date)value);
            }
            throw new IllegalArgumentException("unsupported value type " + value.getClass());
        }
    }
}

