/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.operation.select;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.zats.mimic.AgentException;
import org.zkoss.zats.mimic.ComponentAgent;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.EventDataManager;
import org.zkoss.zats.mimic.impl.OperationAgentBuilder;
import org.zkoss.zats.mimic.impl.operation.AgentDelegator;
import org.zkoss.zats.mimic.operation.MultipleSelectAgent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.SelectEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultipleSelectAgentBuilder
implements OperationAgentBuilder<ComponentAgent, MultipleSelectAgent> {
    @Override
    public Class<MultipleSelectAgent> getOperationClass() {
        return MultipleSelectAgent.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractMultipleSelectAgentImpl
    extends AgentDelegator<ComponentAgent>
    implements MultipleSelectAgent {
        public AbstractMultipleSelectAgentImpl(ComponentAgent target) {
            super(target);
        }

        @Override
        public void select() {
            HashSet<String> selected;
            if (this.isMultiple()) {
                selected = new HashSet<String>();
                this.collectSelectedItems(selected);
                if (selected.contains(((ComponentAgent)this.target).getUuid())) {
                    return;
                }
            } else {
                throw new AgentException(this.target + " isn't multiple selection mode");
            }
            selected.add(((ComponentAgent)this.target).getUuid());
            this.postUpdate(this.getEventTarget(), selected);
        }

        @Override
        public void deselect() {
            HashSet<String> selected;
            if (this.isMultiple()) {
                selected = new HashSet<String>();
                this.collectSelectedItems(selected);
                if (!selected.contains(((ComponentAgent)this.target).getUuid())) {
                    return;
                }
            } else {
                throw new AgentException(this.target + " isn't multiple selection mode");
            }
            selected.remove(((ComponentAgent)this.target).getUuid());
            this.postUpdate(this.getEventTarget(), selected);
        }

        private void postUpdate(Component component, Set<String> selected) {
            String desktopId = ((ComponentAgent)this.target).getDesktop().getId();
            SelectEvent event = new SelectEvent("onSelect", component, selected, (Component)((ComponentAgent)this.target).getDelegatee());
            Map<String, Object> data = EventDataManager.getInstance().build((Event)event);
            ClientCtrl ctrl = (ClientCtrl)((Object)((ComponentAgent)this.target).getClient());
            ctrl.postUpdate(desktopId, component.getUuid(), event.getName(), data, false);
            ctrl.flush(desktopId);
        }

        protected abstract Component getEventTarget();

        protected abstract boolean isMultiple();

        protected abstract void collectSelectedItems(Set<String> var1);
    }
}

